/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.gradle.plugins.tasks.ConfigUtils;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import com.zaxxer.hikari.HikariConfig;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class DataSourceExtension {
    public DataSourceExtension() {
        this.getProperties().from(new Object[0]);
    }

    @Internal
    public void call(Action<DataSourceExtension> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<String> getDriverClassName();

    @Input
    @Optional
    public abstract Property<String> getJdbcUrl();

    @Input
    @Optional
    public abstract Property<String> getUsername();

    @Input
    @Optional
    public abstract Property<String> getPassword();

    @Input
    @Optional
    public abstract Property<String> getCatalog();

    @Input
    @Optional
    public abstract Property<String> getSchema();

    @Input
    @Optional
    public abstract Property<Boolean> getAutoCommit();

    @Input
    @Optional
    public abstract Property<Boolean> getAllowPoolSuspension();

    @Input
    @Optional
    public abstract Property<Integer> getMaximumPoolSize();

    @Input
    @Optional
    public abstract Property<Long> getIdleTimeout();

    @Input
    @Optional
    public abstract Property<Long> getInitializationFailTimeout();

    @Input
    @Optional
    public abstract Property<Boolean> getIsolateInternalQueries();

    @Input
    @Optional
    public abstract Property<Long> getKeepaliveTime();

    @Input
    @Optional
    public abstract Property<Integer> getMinimumIdle();

    @Input
    @Optional
    public abstract Property<Long> getValidationTimeout();

    @Input
    @Optional
    public abstract Property<Long> getLeakDetectionThreshold();

    @Input
    @Optional
    public abstract Property<Long> getMaxLifetime();

    @Input
    @Optional
    public abstract Property<String> getPoolName();

    @Input
    @Optional
    public abstract Property<String> getConnectionInitSql();

    @Input
    @Optional
    public abstract Property<String> getConnectionTestQuery();

    @Input
    @Optional
    public abstract Property<Long> getConnectionTimeout();

    @Input
    @Optional
    public abstract Property<String> getTransactionIsolation();

    @Input
    @Optional
    public abstract Property<Boolean> getRegisterMbeans();

    @InputFile
    @Optional
    public abstract ConfigurableFileCollection getProperties();

    public void properties(Object ... paths) {
        this.getProperties().from(paths);
    }

    @Internal
    public void setConfig(HikariConfig config) {
        if (!this.getProperties().isEmpty()) {
            Map map = CommonUtils.map();
            ConfigUtils.readConfig(null, map, this.getProperties().getFiles());
            for (Map.Entry entry : map.entrySet()) {
                SimpleBeanUtils.setValueCI((Object)config, (String)((String)entry.getKey()), entry.getValue());
            }
        }
        if (this.getDriverClassName().isPresent()) {
            config.setJdbcUrl((String)this.getJdbcUrl().get());
        }
        if (this.getDriverClassName().isPresent()) {
            config.setDriverClassName((String)this.getDriverClassName().get());
        }
        if (this.getAutoCommit().isPresent()) {
            config.setAutoCommit(((Boolean)this.getAutoCommit().get()).booleanValue());
        }
        if (this.getAllowPoolSuspension().isPresent()) {
            config.setAllowPoolSuspension(((Boolean)this.getAllowPoolSuspension().get()).booleanValue());
        }
        if (this.getUsername().isPresent()) {
            config.setUsername((String)this.getUsername().get());
        }
        if (this.getPassword().isPresent()) {
            config.setPassword((String)this.getPassword().get());
        }
        if (this.getCatalog().isPresent()) {
            config.setCatalog((String)this.getCatalog().getOrNull());
        }
        if (this.getConnectionInitSql().isPresent()) {
            config.setConnectionInitSql((String)this.getConnectionInitSql().get());
        }
        if (this.getConnectionTestQuery().isPresent()) {
            config.setConnectionTestQuery((String)this.getConnectionTestQuery().get());
        }
        if (this.getConnectionTimeout().isPresent()) {
            config.setConnectionTimeout(((Long)this.getConnectionTimeout().get()).longValue());
        }
        if (this.getIsolateInternalQueries().isPresent()) {
            config.setIsolateInternalQueries(((Boolean)this.getIsolateInternalQueries().get()).booleanValue());
        }
        if (this.getInitializationFailTimeout().isPresent()) {
            config.setInitializationFailTimeout(((Long)this.getInitializationFailTimeout().get()).longValue());
        }
        if (this.getIdleTimeout().isPresent()) {
            config.setIdleTimeout(((Long)this.getIdleTimeout().get()).longValue());
        }
        if (this.getKeepaliveTime().isPresent()) {
            config.setKeepaliveTime(((Long)this.getKeepaliveTime().get()).longValue());
        }
        if (this.getLeakDetectionThreshold().isPresent()) {
            config.setLeakDetectionThreshold(((Long)this.getLeakDetectionThreshold().get()).longValue());
        }
        if (this.getMaximumPoolSize().isPresent()) {
            config.setMaximumPoolSize(((Integer)this.getMaximumPoolSize().get()).intValue());
        }
        if (this.getMaxLifetime().isPresent()) {
            config.setMaxLifetime(((Long)this.getMaxLifetime().get()).longValue());
        }
        if (this.getMinimumIdle().isPresent()) {
            config.setMinimumIdle(((Integer)this.getMinimumIdle().get()).intValue());
        }
        if (this.getPoolName().isPresent()) {
            config.setPoolName((String)this.getPoolName().get());
        }
        if (this.getRegisterMbeans().isPresent()) {
            config.setRegisterMbeans(((Boolean)this.getRegisterMbeans().get()).booleanValue());
        }
        if (this.getSchema().isPresent()) {
            config.setSchema((String)this.getSchema().get());
        }
        if (this.getTransactionIsolation().isPresent()) {
            config.setTransactionIsolation((String)this.getTransactionIsolation().get());
        }
        if (this.getValidationTimeout().isPresent()) {
            config.setValidationTimeout(((Long)this.getValidationTimeout().get()).longValue());
        }
    }

    @Internal
    public HikariConfig toConfig() {
        HikariConfig config = new HikariConfig();
        this.setConfig(config);
        return config;
    }
}

