/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.gradle.plugins.extension.DataSourceExtension;
import com.sqlapp.gradle.plugins.tasks.AbstractTask;
import com.sqlapp.jdbc.JdbcUtils;
import com.sqlapp.jdbc.SqlappDataSource;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;

public abstract class AbstractDbTask
extends AbstractTask {
    @Internal
    protected String getDriverClassName(String driverClassName, String url) {
        if (driverClassName == null) {
            driverClassName = JdbcUtils.getDriverClassNameByUrl((String)url);
        }
        return driverClassName;
    }

    @Internal
    protected DataSource createDataSource(Property<DataSourceExtension> prop) {
        return this.createDataSource((DataSourceExtension)prop.get());
    }

    @Internal
    protected DataSource createDataSource(DataSourceExtension obj) {
        boolean debug = (Boolean)this.getDebug().getOrElse((Object)false);
        if (!debug) {
            HikariDataSource ds = new HikariDataSource(obj.toConfig());
            return ds;
        }
        SqlappDataSource sds = new SqlappDataSource((DataSource)new HikariDataSource(obj.toConfig()));
        sds.setDebug(true);
        return sds;
    }
}

