/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.tasks;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.GenerateSimpleSqlCommand;
import com.sqlapp.data.db.sql.FileSqlExecutor;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.StandardOutSqlExecutor;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.gradle.plugins.extension.GenerateSqlExtension;
import com.sqlapp.gradle.plugins.tasks.AbstractGenerateSqlTask;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.File;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateSqlTask
extends AbstractGenerateSqlTask {
    @TaskAction
    public void exec() {
        GenerateSimpleSqlCommand command = new GenerateSimpleSqlCommand();
        GenerateSqlExtension obj = (GenerateSqlExtension)this.getProject().getExtensions().getByType(GenerateSqlExtension.class);
        obj.setCommand((AbstractCommand)command, (Boolean)this.getDebug().getOrElse((Object)false));
        try {
            DbCommonObject xmlObj = SchemaUtils.readXml((File)((File)obj.getTargetFile().getAsFile().get()));
            command.setTarget(xmlObj);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        if (obj.getSchemaOptions().isPresent()) {
            command.setSchemaOption((Options)obj.getSchemaOptions().get());
        }
        File outputPath = ((Directory)obj.getOutputPath().get()).getAsFile();
        this.run((AbstractCommand)command);
        if (outputPath == null) {
            StandardOutSqlExecutor executor = new StandardOutSqlExecutor();
            this.execute((SqlExecutor)executor, command.getOperations());
        } else {
            if (((Boolean)this.getDebug().getOrElse((Object)false)).booleanValue()) {
                StandardOutSqlExecutor executor = new StandardOutSqlExecutor();
                this.execute((SqlExecutor)executor, command.getOperations());
            }
            long step = (Long)obj.getChangeNumberStep().getOrElse((Object)10L);
            String encoding = (String)obj.getEncoding().getOrElse((Object)"UTF-8");
            if (((Boolean)obj.getOutputAsMultiFiles().getOrElse((Object)true)).booleanValue()) {
                if (!outputPath.exists()) {
                    outputPath.mkdirs();
                }
                long current = this.getCurrentNumber(obj);
                String suffix = this.getFileSuffix(obj);
                for (SqlOperation operation : command.getOperations()) {
                    String fname = this.getFilename(current += step, obj.getOrElseNumberOfDigits(), this.toString(operation.getSqlType()) + "_" + this.getName(operation), suffix);
                    File file = new File(outputPath, fname);
                    FileSqlExecutor executor = new FileSqlExecutor(file, encoding);
                    this.execute((SqlExecutor)executor, operation);
                }
            } else {
                FileUtils.createParentDirectory((File)outputPath);
                SqlOperation operation = (SqlOperation)CommonUtils.first((List)command.getOperations());
                if (outputPath.exists() && outputPath.isDirectory()) {
                    long current = this.getCurrentNumber(obj);
                    String suffix = this.getFileSuffix(obj);
                    String fname = this.getFilename(current += step, obj.getOrElseNumberOfDigits(), this.toString(operation.getSqlType()) + "_" + this.getName(operation), suffix);
                    File file = new File(outputPath, fname);
                    FileSqlExecutor executor = new FileSqlExecutor(file, encoding);
                    this.execute((SqlExecutor)executor, command.getOperations());
                    return;
                }
                FileSqlExecutor executor = new FileSqlExecutor(outputPath, encoding);
                this.execute((SqlExecutor)executor, command.getOperations());
            }
        }
    }
}

