/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.gradle.plugins.extension.AbstractExtension;
import com.sqlapp.gradle.plugins.properties.ConsoleOutputLevelTaskProperty;
import com.sqlapp.gradle.plugins.properties.ContextTaskProperty;
import com.sqlapp.gradle.plugins.properties.DebugTaskProperty;
import com.sqlapp.gradle.plugins.properties.TaskPropertiesEnum;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractTask<T extends AbstractCommand, S>
extends DefaultTask
implements DebugTaskProperty,
ContextTaskProperty,
ConsoleOutputLevelTaskProperty {
    private T command;
    private S extension;

    public AbstractTask() {
        AbstractExtension ext;
        TaskPropertiesEnum.initializeAll(this.getProject(), this);
        this.command = this.createCommand();
        this.extension = this.createExtension(this.getProject());
        if (this.extension instanceof AbstractExtension && (ext = (AbstractExtension)this.extension).getEnable().isPresent()) {
            this.setEnabled((Boolean)ext.getEnable().get());
        }
    }

    @TaskAction
    public void exec() {
        if (this.extension != null) {
            TaskPropertiesEnum.setAllProperties(this.extension, this.command);
            AbstractExtension ext = (AbstractExtension)this.extension;
            ext.initializeCommand((AbstractCommand)this.command);
        } else {
            TaskPropertiesEnum.setAllProperties(this, this.command);
        }
        this.exec(this.command, this.extension);
    }

    @Internal
    protected abstract T createCommand();

    @Internal
    protected abstract S createExtension(Project var1);

    @Internal
    protected abstract void exec(T var1, S var2);

    @Internal
    protected void run(AbstractCommand command) {
        if (this.extension == null) {
            TaskPropertiesEnum.setDebugProperties(this, command);
        }
        if (this.getEnabled()) {
            try {
                command.run();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        } else {
            System.out.println("This task is disabled.");
        }
    }
}

