/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins;

import com.sqlapp.gradle.plugins.ConfigUtils;
import com.sqlapp.util.CommonUtils;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class EnvironmentTask
extends DefaultTask {
    @Optional
    @InputDirectory
    public abstract DirectoryProperty getEnvPath();

    @TaskAction
    public void exec() {
        File envDir;
        String env = System.getProperty("env");
        if (env == null && this.getProject().hasProperty("env")) {
            env = (String)this.getProject().getProperties().get("env");
        }
        File envPath = ((Directory)this.getEnvPath().get()).getAsFile();
        envPath = this.getEnvPath().isPresent() ? ((Directory)this.getEnvPath().get()).getAsFile() : new File("src/main/environment");
        if (!envPath.exists()) {
            System.err.println("envPath does not exists. [" + envPath.getAbsolutePath() + "]");
            throw new InvalidUserDataException("envPath does not exists. [" + envPath.getAbsolutePath() + "]");
        }
        if (env == null) {
            HashMap<String, File> childMap = new HashMap<String, File>();
            File[] files = envPath.listFiles();
            if (files != null) {
                for (File child : files) {
                    if (!child.isDirectory()) continue;
                    childMap.put(child.getName(), child);
                }
            }
            if (childMap.isEmpty()) {
                System.err.println("No environment found. path=" + envPath.getAbsolutePath());
                throw new InvalidUserDataException("No environment found. path=" + envPath.getAbsolutePath());
            }
            if (childMap.size() == 1) {
                env = (String)CommonUtils.first(childMap.keySet());
            } else {
                String envText = this.getEnvText(childMap.keySet());
                Console console = System.console();
                if (console != null) {
                    while (!childMap.containsKey(env = console.readLine("%s:", "select environment.[" + envText + "]"))) {
                    }
                } else {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        System.out.println("select environment.[" + envText + "]:");
                        try {
                            env = br.readLine();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    } while (!childMap.containsKey(env));
                }
            }
        }
        if (!(envDir = new File(envPath, env)).exists()) {
            System.out.println("Env direcotry does not exists. path=" + envDir.getAbsolutePath());
            return;
        }
        if (!envDir.isDirectory()) {
            System.out.println("Env direcotry is not a directory. path=" + envDir.getAbsolutePath());
            return;
        }
        System.out.println("Environment dir [" + envDir.getAbsolutePath() + "] was selected.");
        ConfigSlurper slurper = new ConfigSlurper();
        Map props = this.getProject().getProperties();
        slurper.setBinding(props);
        ConfigObject config = new ConfigObject();
        File[] files = envDir.listFiles();
        if (files != null) {
            ConfigUtils.readConfig(this.getProject().getProperties(), (Map)config, files);
        }
        System.out.println("project.name=" + this.getProject().getName());
        if (this.getProject().getParent() != null) {
            System.out.println("project.parent.name=" + this.getProject().getParent().getName());
        }
        config.forEach((k, v) -> {
            String key = (String)k;
            Object value = v;
            Object obj = this.getProject().getExtensions().findByName(key);
            props.put(key, value);
            if (obj == null) {
                this.getProject().getExtensions().add(key, value);
            }
        });
    }

    private String getEnvText(Set<String> set) {
        StringBuilder builder = new StringBuilder();
        for (String value : set) {
            builder.append(value);
            builder.append(",");
        }
        return builder.substring(0, builder.length() - 1);
    }
}

