/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.GenerateDiffSqlCommand;
import com.sqlapp.data.db.sql.FileSqlExecutor;
import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.StandardOutSqlExecutor;
import com.sqlapp.gradle.plugins.AbstractGenerateSqlTask;
import com.sqlapp.gradle.plugins.extension.GenerateDiffSqlExtension;
import com.sqlapp.util.FileUtils;
import java.io.File;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;

public abstract class GenerateDiffSqlTask
extends AbstractGenerateSqlTask<GenerateDiffSqlCommand, GenerateDiffSqlExtension> {
    @Override
    protected GenerateDiffSqlCommand createCommand() {
        return new GenerateDiffSqlCommand();
    }

    @Override
    protected GenerateDiffSqlExtension createExtension(Project project) {
        GenerateDiffSqlExtension obj = (GenerateDiffSqlExtension)project.getExtensions().getByType(GenerateDiffSqlExtension.class);
        return obj;
    }

    @Override
    protected void exec(GenerateDiffSqlCommand command, GenerateDiffSqlExtension obj) {
        File outputDirectory = null;
        if (obj.getOutputDirectory().isPresent()) {
            outputDirectory = ((Directory)obj.getOutputDirectory().get()).getAsFile();
        }
        String encoding = (String)obj.getEncoding().getOrElse((Object)"UTF-8");
        this.run((AbstractCommand)command);
        if (command.getSqlOperations().isEmpty()) {
            return;
        }
        if (outputDirectory == null) {
            StandardOutSqlExecutor executor = new StandardOutSqlExecutor();
            this.execute((SqlExecutor)executor, command.getSqlOperations());
        } else {
            if (((Boolean)this.getDebug().getOrElse((Object)false)).booleanValue()) {
                StandardOutSqlExecutor executor = new StandardOutSqlExecutor();
                this.execute((SqlExecutor)executor, command.getSqlOperations().toArray(new SqlOperation[0]));
            }
            long step = obj.getOrElseChangeNumberStep();
            if (((Boolean)obj.getOutputAsMultiFiles().getOrElse((Object)true)).booleanValue()) {
                if (!outputDirectory.exists()) {
                    outputDirectory.mkdirs();
                }
                long current = this.getCurrentNumber(obj);
                String suffix = this.getFileSuffix(obj);
                for (SqlOperation operation : command.getSqlOperations()) {
                    File file = new File(outputDirectory, this.getFilename(current += step, obj.getOrElseNumberOfDigits(), this.toString(operation.getSqlType()) + "_" + this.getName(operation), suffix));
                    FileSqlExecutor executor = new FileSqlExecutor(file, encoding);
                    this.execute((SqlExecutor)executor, operation);
                }
            } else {
                FileUtils.createParentDirectory((File)outputDirectory);
                List sqlOperations = command.getSqlOperations();
                if (sqlOperations.isEmpty()) {
                    return;
                }
                List reverseSqlOperations = null;
                if (((Boolean)obj.getWithVersionDown().getOrElse((Object)false)).booleanValue()) {
                    command.swap();
                    this.run((AbstractCommand)command);
                    reverseSqlOperations = command.getSqlOperations();
                    reverseSqlOperations.add(0, SqlOperation.EMPTY_LINE_OPERATION);
                    reverseSqlOperations.add(0, SqlOperation.UNDO_OPERATION);
                    reverseSqlOperations.add(0, SqlOperation.EMPTY_LINE_OPERATION);
                    reverseSqlOperations.add(0, SqlOperation.COMMENT_SEPARATOR_OPERATION);
                    sqlOperations.addAll(reverseSqlOperations);
                }
                SqlOperation operation = this.getSqlOperation(sqlOperations);
                if (outputDirectory.exists() && outputDirectory.isDirectory()) {
                    long current = this.getCurrentNumber(obj);
                    String suffix = this.getFileSuffix(obj);
                    File file = new File(outputDirectory, this.getFilename(current += step, obj.getOrElseNumberOfDigits(), this.toString(operation.getSqlType()) + "_" + this.getName(operation), suffix));
                    FileSqlExecutor executor = new FileSqlExecutor(file, encoding);
                    this.execute((SqlExecutor)executor, sqlOperations);
                    return;
                }
                FileSqlExecutor executor = new FileSqlExecutor(outputDirectory, encoding);
                this.execute((SqlExecutor)executor, sqlOperations);
            }
        }
    }

    private SqlOperation getSqlOperation(List<SqlOperation> sqlOperations) {
        for (SqlOperation sqlOperation : sqlOperations) {
            if (sqlOperation.getSqlType() == SqlType.SET_SEARCH_PATH_TO_SCHEMA) continue;
            return sqlOperation;
        }
        return sqlOperations.get(0);
    }
}

