/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.GenerateSimpleSqlCommand;
import com.sqlapp.data.db.sql.FileSqlExecutor;
import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.StandardOutSqlExecutor;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.gradle.plugins.AbstractGenerateSqlTask;
import com.sqlapp.gradle.plugins.extension.GenerateSqlExtension;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.File;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;

public abstract class GenerateSqlTask
extends AbstractGenerateSqlTask<GenerateSimpleSqlCommand, GenerateSqlExtension> {
    @Override
    protected GenerateSimpleSqlCommand createCommand() {
        return new GenerateSimpleSqlCommand();
    }

    @Override
    protected GenerateSqlExtension createExtension(Project project) {
        GenerateSqlExtension obj = (GenerateSqlExtension)project.getExtensions().getByType(GenerateSqlExtension.class);
        return obj;
    }

    @Override
    protected void exec(GenerateSimpleSqlCommand command, GenerateSqlExtension obj) {
        try {
            DbCommonObject xmlObj = SchemaUtils.readXml((File)((File)obj.getTargetFile().getAsFile().get()));
            command.setTarget(xmlObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File outputDirectory = null;
        if (obj.getOutputDirectory().isPresent()) {
            outputDirectory = ((Directory)obj.getOutputDirectory().get()).getAsFile();
        }
        this.run((AbstractCommand)command);
        if (outputDirectory == null) {
            StandardOutSqlExecutor executor = new StandardOutSqlExecutor();
            this.execute((SqlExecutor)executor, command.getSqlOperations());
        } else {
            if (((Boolean)this.getDebug().getOrElse((Object)false)).booleanValue()) {
                StandardOutSqlExecutor executor = new StandardOutSqlExecutor();
                this.execute((SqlExecutor)executor, command.getSqlOperations());
            }
            long step = obj.getOrElseChangeNumberStep();
            String encoding = (String)obj.getEncoding().getOrElse((Object)"UTF-8");
            if (((Boolean)obj.getOutputAsMultiFiles().getOrElse((Object)true)).booleanValue()) {
                if (!outputDirectory.exists()) {
                    outputDirectory.mkdirs();
                }
                long current = this.getCurrentNumber(obj);
                String suffix = this.getFileSuffix(obj);
                for (SqlOperation operation : command.getSqlOperations()) {
                    String fname = this.getFilename(current += step, obj.getOrElseNumberOfDigits(), this.toString(operation.getSqlType()) + "_" + this.getName(operation), suffix);
                    File file = new File(outputDirectory, fname);
                    FileSqlExecutor executor = new FileSqlExecutor(file, encoding);
                    this.execute((SqlExecutor)executor, operation);
                }
            } else {
                FileUtils.createParentDirectory((File)outputDirectory);
                SqlOperation operation = (SqlOperation)CommonUtils.first((List)command.getSqlOperations());
                if (outputDirectory.exists() && outputDirectory.isDirectory()) {
                    long current = this.getCurrentNumber(obj);
                    String suffix = this.getFileSuffix(obj);
                    String fname = this.getFilename(current += step, obj.getOrElseNumberOfDigits(), this.toString(operation.getSqlType()) + "_" + this.getName(operation), suffix);
                    File file = new File(outputDirectory, fname);
                    FileSqlExecutor executor = new FileSqlExecutor(file, encoding);
                    this.execute((SqlExecutor)executor, command.getSqlOperations());
                    return;
                }
                FileSqlExecutor executor = new FileSqlExecutor(outputDirectory, encoding);
                this.execute((SqlExecutor)executor, command.getSqlOperations());
            }
        }
    }
}

