/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.html.GenerateHtmlCommand;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.gradle.plugins.extension.AbstractSchemaFileExtension;
import com.sqlapp.gradle.plugins.extension.RenderOptionExtension;
import com.sqlapp.gradle.plugins.properties.DictionaryFileDirectoryTaskProperty;
import com.sqlapp.gradle.plugins.properties.DictionaryFileTypeTaskProperty;
import com.sqlapp.gradle.plugins.properties.DirectoryTaskProperty;
import com.sqlapp.gradle.plugins.properties.FileDirectoryTaskProperty;
import com.sqlapp.gradle.plugins.properties.FileFilterTaskProperty;
import com.sqlapp.gradle.plugins.properties.OutputDirectoryTaskProperty;
import com.sqlapp.gradle.plugins.properties.PlaceholderTaskProperty;
import com.sqlapp.gradle.plugins.properties.TargetFileTaskProperty;
import com.sqlapp.gradle.plugins.properties.UseSchemaNameDirectoryTaskProperty;
import com.sqlapp.gradle.plugins.properties.UseTableNameDirectoryTaskProperty;
import com.sqlapp.graphviz.command.OutputFormat;
import java.io.File;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class GenerateHtmlExtension
extends AbstractSchemaFileExtension
implements FileFilterTaskProperty,
FileDirectoryTaskProperty,
DirectoryTaskProperty,
OutputDirectoryTaskProperty,
PlaceholderTaskProperty,
UseSchemaNameDirectoryTaskProperty,
UseTableNameDirectoryTaskProperty,
DictionaryFileDirectoryTaskProperty,
DictionaryFileTypeTaskProperty,
TargetFileTaskProperty {
    @Input
    @Optional
    private Predicate<File> fileFilter = f -> true;

    @Inject
    public GenerateHtmlExtension(Project project) {
        super(project);
    }

    public void call(Action<GenerateHtmlExtension> cons) {
        cons.execute((Object)this);
    }

    @Input
    @Optional
    public abstract Property<RenderOptionExtension> getRenderOptions();

    @Input
    @Optional
    public abstract Property<String> getDiagramFont();

    @Input
    @Optional
    public abstract Property<String> getDiagramFormat();

    @Input
    @Optional
    public abstract Property<String> getDot();

    @Input
    @Optional
    public abstract Property<Boolean> getMultiThread();

    @Override
    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getForeignKeyDefinitionDirectory();

    @Input
    @Optional
    public abstract Property<Function<ForeignKeyConstraint, String>> getVirtualForeignKeyLabel();

    @Override
    @Internal
    public void initializeCommand(AbstractCommand command) {
        super.initializeCommand(command);
        if (command instanceof GenerateHtmlCommand) {
            GenerateHtmlCommand com = (GenerateHtmlCommand)command;
            if (this.getRenderOptions().isPresent()) {
                ((RenderOptionExtension)this.getRenderOptions().get()).setRenderOption(com.getRenderOptions());
            }
            if (this.getDiagramFont().isPresent()) {
                com.setDiagramFont((String)this.getDiagramFont().get());
            }
            if (this.getDiagramFormat().isPresent()) {
                com.setDiagramFormat(OutputFormat.parse((String)((String)this.getDiagramFormat().get())));
            }
            if (this.getDot().isPresent()) {
                com.setDot((String)this.getDot().get());
            }
            if (this.getMultiThread().isPresent()) {
                com.setMultiThread(((Boolean)this.getMultiThread().get()).booleanValue());
            }
            if (this.getForeignKeyDefinitionDirectory().isPresent()) {
                com.setForeignKeyDefinitionDirectory(((Directory)this.getForeignKeyDefinitionDirectory().get()).getAsFile());
            }
            if (this.getVirtualForeignKeyLabel().isPresent()) {
                com.setVirtualForeignKeyLabel((Function)this.getVirtualForeignKeyLabel().get());
            }
        }
    }
}

