/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.gradle.plugins.extension;

import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.db.command.version.VersionUpCommand;
import com.sqlapp.gradle.plugins.extension.AbstractDbExtension;
import com.sqlapp.gradle.plugins.extension.ChangeTableExtension;
import com.sqlapp.gradle.plugins.extension.DataSourceExtension;
import com.sqlapp.gradle.plugins.properties.EncodingTaskProperty;
import com.sqlapp.gradle.plugins.properties.FileDirectoryTaskProperty;
import com.sqlapp.gradle.plugins.properties.PlaceholderTaskProperty;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public abstract class VersionUpExtension
extends AbstractDbExtension
implements FileDirectoryTaskProperty,
PlaceholderTaskProperty,
EncodingTaskProperty {
    @Inject
    public VersionUpExtension(Project project) {
        super(project);
        this.setDataSource((DataSourceExtension)this.getProject().getObjects().newInstance(DataSourceExtension.class, new Object[0]));
    }

    public void call(Action<VersionUpExtension> cons) {
        cons.execute((Object)this);
    }

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getSqlDirectory();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getDownSqlDirectory();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getSetupSqlDirectory();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getFinalizeSqlDirectory();

    @Input
    @Optional
    public abstract Property<String> getLastChangeNumber();

    @Input
    @Optional
    public abstract Property<Boolean> getShowVersionOnly();

    @Input
    @Optional
    public abstract Property<Boolean> getWithSeriesNumber();

    @Nested
    public abstract ChangeTableExtension getChangeTable();

    public void changeTable(Action<? super ChangeTableExtension> action) {
        action.execute((Object)this.getChangeTable());
    }

    @Override
    @Internal
    public void initializeCommand(AbstractCommand command) {
        super.initializeCommand(command);
        if (command instanceof VersionUpCommand) {
            VersionUpCommand com = (VersionUpCommand)command;
            if (this.getSqlDirectory().isPresent()) {
                com.setSqlDirectory(((Directory)this.getSqlDirectory().get()).getAsFile());
            }
            if (this.getDownSqlDirectory().isPresent()) {
                com.setDownSqlDirectory(((Directory)this.getDownSqlDirectory().get()).getAsFile());
            }
            if (this.getSetupSqlDirectory().isPresent()) {
                com.setSetupSqlDirectory(((Directory)this.getSetupSqlDirectory().get()).getAsFile());
            }
            if (this.getFinalizeSqlDirectory().isPresent()) {
                com.setFinalizeSqlDirectory(((Directory)this.getFinalizeSqlDirectory().get()).getAsFile());
            }
            if (this.getLastChangeNumber().isPresent()) {
                com.setLastChangeToApply(Long.valueOf((String)this.getLastChangeNumber().get()));
            }
            if (this.getShowVersionOnly().isPresent()) {
                com.setShowVersionOnly(((Boolean)this.getShowVersionOnly().get()).booleanValue());
            }
            if (this.getWithSeriesNumber().isPresent()) {
                com.setWithSeriesNumber(((Boolean)this.getWithSeriesNumber().get()).booleanValue());
            }
            this.getChangeTable().initializeCommand(command);
        }
    }
}

