/*
 * Copyright (C) 2007-2017 Tatsuo Satoh <multisqllib@gmail.com>
 *
 * This file is part of sqlapp-gradle-plugin.
 *
 * sqlapp-gradle-plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * sqlapp-gradle-plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with sqlapp-gradle-plugin.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sqlapp.gradle.plugins.pojo;

import org.gradle.api.Project;

import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.util.SimpleBeanUtils;

public class TableOptionsPojo extends TableOptions{
	
	Project project;

	public TableOptionsPojo(TableOptions tableOption, Project project) {
		SimpleBeanUtils.copyProperties(tableOption, this);
		this.project=project;
	}

	public TableOptionsPojo() {
		this.project=null;
	}
	
	public TableOptionsPojo(Project project) {
		this.project=project;
	}
	
}
