/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.ArrowType;
import com.sqlapp.graphviz.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;

public class GraphStringBuilder
implements Serializable {
    private static final long serialVersionUID = 6358515277099678728L;
    private List<Object> elements = new ArrayList<Object>();
    private Map<String, Object> map = new TreeMap<String, Object>();
    private boolean withLineBreak = true;
    private int indentLevel = 0;
    private String indentString = "\t";
    private String open = "[";
    private String close = "]";
    private boolean withLastSemiColon = true;
    private String currentIndentString = null;
    private String name;

    public GraphStringBuilder() {
        this.name = null;
    }

    public GraphStringBuilder(String name) {
        this.name = name;
    }

    public GraphStringBuilder put(Object value) {
        this.elements.add(value);
        return this.instance();
    }

    public GraphStringBuilder put(String name, Object value) {
        if (value == null) {
            return this.instance();
        }
        if (value instanceof String) {
            return this.put(name, (String)value);
        }
        if (value instanceof Number) {
            return this.put(name, (Number)value);
        }
        if (value instanceof Enum) {
            return this.put(name, (Enum)value);
        }
        if (value instanceof Color[]) {
            return this.put(name, (Color[])value);
        }
        if (value instanceof ArrowType[]) {
            return this.put(name, (ArrowType[])value);
        }
        return this.put(name, value.toString());
    }

    public GraphStringBuilder put(String name, String value) {
        return this.putInternal(name, value, () -> this.escapedValue(value));
    }

    public GraphStringBuilder putNoEscape(String name, String value) {
        return this.putInternal(name, value, () -> value);
    }

    private String escapedValue(String value) {
        return "\"" + value + "\"";
    }

    public GraphStringBuilder put(String name, Number value) {
        return this.putInternal(name, value, () -> value.toString());
    }

    public GraphStringBuilder put(String name, Enum<?> value) {
        return this.putInternal(name, value, () -> value.toString());
    }

    public GraphStringBuilder put(String name, Color ... value) {
        return this.putInternal(name, value, () -> this.toString(value));
    }

    public GraphStringBuilder put(String name, String ... args) {
        return this.putInternal(name, args, () -> this.toString(args));
    }

    public GraphStringBuilder put(String name, double ... args) {
        return this.putInternal(name, args, () -> this.toString(args));
    }

    public GraphStringBuilder put(String name, ArrowType ... args) {
        return this.putInternal(name, args, () -> this.toString(args));
    }

    protected <T> GraphStringBuilder putInternal(String name, T value, Supplier<String> supplier) {
        if (value == null) {
            if (this.map.containsKey(name)) {
                this.map.remove(name);
            }
            return this.instance();
        }
        this.map.put(name, supplier.get());
        return this.instance();
    }

    private String toString(String ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(arg);
        }
        builder.append("\"");
        return builder.toString();
    }

    private String toString(double ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        boolean first = true;
        for (double arg : args) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(arg);
        }
        builder.append("\"");
        return builder.toString();
    }

    private String toString(Color ... value) {
        if (value == null || value.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        boolean first = true;
        for (Color color : value) {
            if (!first) {
                builder.append(":");
            } else {
                first = false;
            }
            builder.append((Object)color);
        }
        builder.append("\"");
        return builder.toString();
    }

    private String toString(ArrowType ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        for (ArrowType arg : args) {
            builder.append((Object)arg);
        }
        builder.append("\"");
        return builder.toString();
    }

    public GraphStringBuilder put(String name, Boolean value) {
        if (value == null) {
            if (this.map.containsKey(name)) {
                this.map.remove(name);
            }
            return this.instance();
        }
        this.map.put(name, value.toString());
        return this.instance();
    }

    protected GraphStringBuilder instance() {
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null && this.name.length() > 0) {
            builder.append(this.name);
        } else if (this.isEmpty()) {
            return "";
        }
        if (this.isEmpty()) {
            if (this.isWithLastSemiColon()) {
                builder.append(";");
            }
            return builder.toString();
        }
        builder.append(" ").append(this.getOpen());
        this.addIndentLevel(1);
        for (Object obj : this.elements) {
            if (obj == null) continue;
            if (this.withLineBreak) {
                this.lineBreak(builder);
            }
            builder.append(obj.toString());
        }
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (this.withLineBreak) {
                this.lineBreak(builder);
            }
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            String value = entry.getValue().toString();
            builder.append(entry.getKey());
            builder.append("=");
            this.appendValue(builder, value);
        }
        this.addIndentLevel(-1);
        if (this.withLineBreak) {
            this.lineBreak(builder);
        }
        builder.append(this.getClose());
        if (this.name != null && (this.name.startsWith("graph") || this.name.startsWith("digraph") || this.name.startsWith("subgraph"))) {
            if (!";".equals(this.getClose()) && !"}".equals(this.getClose()) && this.isWithLastSemiColon()) {
                builder.append(";");
            }
        } else if (this.isWithLastSemiColon() && !";".equals(this.getClose())) {
            builder.append(";");
        }
        return builder.toString();
    }

    private GraphStringBuilder lineBreak(StringBuilder builder) {
        builder.append("\n");
        this.indent(builder);
        return this.instance();
    }

    private GraphStringBuilder appendValue(StringBuilder builder, String value) {
        builder.append(value);
        return this.instance();
    }

    public String getOpen() {
        return this.open;
    }

    public GraphStringBuilder setOpen(String open) {
        this.open = open;
        return this.instance();
    }

    public String getClose() {
        return this.close;
    }

    public GraphStringBuilder setClose(String close) {
        this.close = close;
        return this.instance();
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public GraphStringBuilder setIndentLevel(int indentLevel) {
        if (indentLevel >= 0) {
            this.indentLevel = indentLevel;
            this.currentIndentString = this.getString(this.indentString, indentLevel);
        }
        return this.instance();
    }

    public GraphStringBuilder addIndentLevel(int addCount) {
        this.setIndentLevel(this.getIndentLevel() + addCount);
        return this.instance();
    }

    public String getIndentString() {
        return this.indentString;
    }

    public GraphStringBuilder setIndentString(String indentString) {
        this.indentString = indentString;
        return this.setIndentLevel(this.getIndentLevel());
    }

    private GraphStringBuilder indent(StringBuilder builder) {
        builder.append(this.currentIndentString);
        return this.instance();
    }

    private String getString(String val, int size) {
        StringBuilder builder = new StringBuilder(val.length() * size);
        for (int i = 0; i < size; ++i) {
            builder.append(val);
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.map.isEmpty() && this.elements.isEmpty() && this.map.isEmpty();
    }

    public boolean isWithLineBreak() {
        return this.withLineBreak;
    }

    public GraphStringBuilder setWithLineBreak(boolean withLineBreak) {
        this.withLineBreak = withLineBreak;
        return this.instance();
    }

    public boolean isWithLastSemiColon() {
        return this.withLastSemiColon;
    }

    public GraphStringBuilder setWithLastSemiColon(boolean withLastSemiColon) {
        this.withLastSemiColon = withLastSemiColon;
        return this.instance();
    }
}

