/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractNode;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.GraphStringBuilder;
import com.sqlapp.graphviz.NodeCollection;
import com.sqlapp.graphviz.Port;
import com.sqlapp.graphviz.PortCollection;
import com.sqlapp.graphviz.Props;
import com.sqlapp.graphviz.RecordLabelBuilder;
import com.sqlapp.graphviz.labeltable.TableElement;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Node
extends AbstractNode<Node> {
    private String name = null;
    @Props
    private String group;
    private NodeCollection parent;
    private PortCollection ports = new PortCollection(this);
    private static Pattern PORT_PATTERN = Pattern.compile("<([^>]+?)>", 40);

    public Node(String name) {
        this.name = name;
    }

    @Override
    public String getEscapedName() {
        return this.escapeName(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Graph getRoot() {
        Graph graph = this.getGraph();
        if (graph.getParent() == null) {
            return null;
        }
        if (this.getParent().getParent() == null) {
            return null;
        }
        return graph.getRoot();
    }

    public Graph getGraph() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getParent();
    }

    @Override
    public Node setLabel(String label) {
        super.setLabel(label);
        this.ports.clear();
        if (label != null) {
            String val = label.trim();
            if (val.startsWith("<") && val.endsWith(">")) {
                return (Node)this.instance();
            }
            Matcher matcher = PORT_PATTERN.matcher(label);
            while (matcher.find()) {
                String value = matcher.group(1);
                this.getPorts().add(new Port(value));
            }
        }
        return (Node)this.instance();
    }

    public Node setLabel(Consumer<RecordLabelBuilder> c) {
        RecordLabelBuilder builder = RecordLabelBuilder.create();
        c.accept(builder);
        return this.setLabel(builder.toString());
    }

    public Node setHtmlLabel(Consumer<TableElement> c) {
        TableElement element = new TableElement(this);
        c.accept(element);
        super.setLabel("<\n" + element.toString() + ">");
        return (Node)this.instance();
    }

    @Override
    protected void initializeLabel(GraphStringBuilder builder) {
        if (this.getLabel() == null) {
            return;
        }
        String val = this.getLabel().trim();
        if (val.startsWith("<") && val.endsWith(">")) {
            builder.putNoEscape("label", this.getLabel());
        } else {
            builder.put("label", this.getLabel());
        }
    }

    public Port getPort(String name) {
        return this.getPorts().get(name);
    }

    @Override
    protected Map<String, Object> getProperties() {
        Map<String, Object> props = super.getProperties();
        this.put(props, "group", this.group);
        return props;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        NodeCollection this$parent = this.getParent();
        NodeCollection other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        PortCollection this$ports = this.getPorts();
        PortCollection other$ports = other.getPorts();
        return !(this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        NodeCollection $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        PortCollection $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        return result;
    }

    private void setName(String name) {
        this.name = name;
    }

    public NodeCollection getParent() {
        return this.parent;
    }

    protected void setParent(NodeCollection parent) {
        this.parent = parent;
    }

    protected PortCollection getPorts() {
        return this.ports;
    }

    protected void setPorts(PortCollection ports) {
        this.ports = ports;
    }
}

