/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractElementCollection;
import com.sqlapp.graphviz.DuplicateNodeException;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.Node;
import java.util.LinkedHashMap;
import java.util.Map;

public class NodeCollection
extends AbstractElementCollection<Node> {
    private static final long serialVersionUID = 6685111479972906357L;
    private Graph parent;
    private Map<String, Node> map = new LinkedHashMap<String, Node>();

    protected NodeCollection(Graph parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renew() {
        LinkedHashMap<String, Node> newMap = new LinkedHashMap<String, Node>();
        this.getList().forEach(c -> {
            if (newMap.containsKey(c.getName())) {
                throw new DuplicateNodeException((Node)c);
            }
            newMap.put(c.getName(), (Node)c);
            newMap.put(c.getEscapedName(), (Node)c);
            c.setParent(this);
        });
        NodeCollection nodeCollection = this;
        synchronized (nodeCollection) {
            this.map = newMap;
        }
    }

    public <T extends Node> T get(String name) {
        return (T)this.map.get(name);
    }

    public <T extends Node> T remove(String name) {
        T node = this.get(name);
        if (node != null) {
            super.remove(node);
        }
        return node;
    }

    protected Graph getParent() {
        return this.parent;
    }
}

