/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractGraphVizElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class RecordLabelBuilder
extends AbstractGraphVizElement {
    private List<Object> elements = new ArrayList<Object>();
    private int brace = 0;

    private RecordLabelBuilder() {
    }

    public static RecordLabelBuilder create() {
        return new RecordLabelBuilder();
    }

    public RecordLabelBuilder addWithPort(String port, String value) {
        this.elements.add("<" + this.escapeName(port) + "> : " + this.escapeName(value));
        return this.instance();
    }

    public RecordLabelBuilder add(String value) {
        this.elements.add(this.escapeName(value));
        return this.instance();
    }

    public RecordLabelBuilder add(Consumer<RecordLabelBuilder> c) {
        RecordLabelBuilder child = RecordLabelBuilder.create();
        this.elements.add(child);
        c.accept(child);
        return this.instance();
    }

    public RecordLabelBuilder add(RecordLabelBuilder builder) {
        this.elements.add(builder);
        return this.instance();
    }

    public RecordLabelBuilder addBrace() {
        ++this.brace;
        return this.instance();
    }

    protected RecordLabelBuilder instance() {
        return this;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < this.brace; ++i) {
            builder.append("{");
        }
        if (!this.elements.isEmpty()) {
            boolean first = true;
            for (Object element : this.elements) {
                if (!first) {
                    builder.append(" | ");
                } else {
                    builder.append(" ");
                    first = false;
                }
                if (element == null) {
                    builder.append("");
                    continue;
                }
                builder.append(element.toString());
            }
            builder.append(" ");
        }
        for (i = 0; i < this.brace; ++i) {
            builder.append("}");
        }
        return builder.toString();
    }
}

