/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.graphviz.ArrowType;
import com.sqlapp.graphviz.DirType;
import com.sqlapp.graphviz.Edge;
import com.sqlapp.graphviz.EdgeStyle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ERDrawMethod {
    IDEF1X{

        @Override
        protected void drawDependent(ForeignKeyConstraint fk, Edge edge) {
            edge.setDir(DirType.back);
            edge.setArrowhead(ArrowType.none);
            edge.setArrowtail(ArrowType.dot);
        }

        @Override
        protected void drawNoDependent(ForeignKeyConstraint fk, Edge edge) {
            this.drawDependent(fk, edge);
            edge.setArrowhead(ArrowType.odiamond);
            edge.setStyle(EdgeStyle.dashed);
        }
    }
    ,
    IE{

        @Override
        protected void drawDependent(ForeignKeyConstraint fk, Edge edge) {
            edge.setDir(DirType.back);
            edge.setArrowhead(ArrowType.none, ArrowType.tee, ArrowType.tee);
            if (this.isPrimary(fk)) {
                edge.setArrowtail(ArrowType.none, ArrowType.tee, ArrowType.odot);
            } else {
                edge.setArrowtail(ArrowType.crow, ArrowType.tee, ArrowType.odot);
            }
        }

        @Override
        protected void drawNoDependent(ForeignKeyConstraint fk, Edge edge) {
            edge.setDir(DirType.back);
            edge.setArrowhead(ArrowType.none, ArrowType.odot);
            if (this.isPrimary(fk)) {
                edge.setArrowtail(ArrowType.none, ArrowType.tee, ArrowType.odot);
            } else {
                edge.setArrowtail(ArrowType.crow, ArrowType.tee, ArrowType.odot);
            }
        }
    };


    public void draw(ForeignKeyConstraint fk, Edge edge) {
        if (this.isDependent(fk)) {
            this.drawDependent(fk, edge);
        } else {
            this.drawNoDependent(fk, edge);
        }
    }

    protected void drawDependent(ForeignKeyConstraint fk, Edge edge) {
    }

    protected void drawNoDependent(ForeignKeyConstraint fk, Edge edge) {
    }

    public boolean isPrimary(ForeignKeyConstraint fk) {
        for (Column column : fk.getColumns()) {
            if (column.isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    public boolean isDependent(ForeignKeyConstraint fk) {
        for (Column column : fk.getColumns()) {
            if (column.isNotNull()) continue;
            return false;
        }
        return true;
    }
}

