/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Partition;
import com.sqlapp.graphviz.labeltable.Align;
import com.sqlapp.graphviz.labeltable.TdElement;
import com.sqlapp.graphviz.labeltable.TrElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import com.sqlapp.util.CommonUtils;
import java.util.function.Function;
import lombok.Generated;

public class PartitionTableHeaderBuilder
extends AbstractSchemaGraphBuilder {
    private int cellSize = 0;
    private String defaultColor = null;
    private String defaultBgcolor = "#58ACFA";
    private Function<Partition, String> name = t -> t.getName();
    private Function<Partition, String> color = t -> this.defaultColor();
    private Function<Partition, String> bgcolor = t -> this.defaultBgcolor();
    private int colspan = 1;

    private PartitionTableHeaderBuilder() {
    }

    public static PartitionTableHeaderBuilder create() {
        PartitionTableHeaderBuilder builder = new PartitionTableHeaderBuilder();
        return builder;
    }

    public int build(Partition partition, TrElement tr) {
        this.createName(partition, tr);
        return this.cellSize;
    }

    private PartitionTableHeaderBuilder createName(Partition partition, TrElement tr) {
        String value = this.name.apply(partition);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(partition, (TdElement)cell);
                cell.setAlign(Align.CENTER);
                cell.setPort(this.getPortName(partition));
                cell.setValue(value);
                if (CommonUtils.isEmpty((CharSequence)partition.getDisplayRemarks())) {
                    cell.setTooltip(partition.getRemarks());
                } else {
                    cell.setTooltip(partition.getDisplayRemarks());
                }
            });
            this.addCellSize();
        }
        return this.instance();
    }

    private String getPortName(Partition partition) {
        return SchemaGraphUtils.getName(partition);
    }

    private PartitionTableHeaderBuilder setCommonAttribute(Partition partition, TdElement cell) {
        cell.setAlign(Align.CENTER);
        cell.setColor(this.getTableColor(partition));
        cell.setBgcolor(this.getTableBgcolor(partition));
        if (this.colspan > 1) {
            cell.setColspan(this.colspan);
        }
        return this.instance();
    }

    private PartitionTableHeaderBuilder instance() {
        return this;
    }

    private String getTableColor(Partition partition) {
        String value = this.color.apply(partition);
        if (value == null) {
            return this.defaultColor();
        }
        return value;
    }

    private String getTableBgcolor(Partition partition) {
        String value = this.bgcolor.apply(partition);
        if (value == null) {
            return this.defaultBgcolor();
        }
        return value;
    }

    private void addCellSize() {
        this.cellSize += this.colspan;
    }

    @Generated
    public int cellSize() {
        return this.cellSize;
    }

    @Generated
    public String defaultColor() {
        return this.defaultColor;
    }

    @Generated
    public String defaultBgcolor() {
        return this.defaultBgcolor;
    }

    @Generated
    public Function<Partition, String> name() {
        return this.name;
    }

    @Generated
    public Function<Partition, String> color() {
        return this.color;
    }

    @Generated
    public Function<Partition, String> bgcolor() {
        return this.bgcolor;
    }

    @Generated
    public int colspan() {
        return this.colspan;
    }

    @Generated
    public PartitionTableHeaderBuilder cellSize(int cellSize) {
        this.cellSize = cellSize;
        return this;
    }

    @Generated
    public PartitionTableHeaderBuilder defaultColor(String defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    @Generated
    public PartitionTableHeaderBuilder defaultBgcolor(String defaultBgcolor) {
        this.defaultBgcolor = defaultBgcolor;
        return this;
    }

    @Generated
    public PartitionTableHeaderBuilder name(Function<Partition, String> name) {
        this.name = name;
        return this;
    }

    @Generated
    public PartitionTableHeaderBuilder color(Function<Partition, String> color) {
        this.color = color;
        return this;
    }

    @Generated
    public PartitionTableHeaderBuilder bgcolor(Function<Partition, String> bgcolor) {
        this.bgcolor = bgcolor;
        return this;
    }

    @Generated
    public PartitionTableHeaderBuilder colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }
}

