/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.command;

import com.sqlapp.graphviz.command.DotCommandException;
import com.sqlapp.graphviz.command.DotRuntimeException;
import com.sqlapp.graphviz.command.OutputFormat;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotRuntime {
    private static final String LINE_SEPARATOR = System.getProperty("file.separator");
    private static final boolean WIN32 = "\\".equals(LINE_SEPARATOR);
    private String dot;
    private File dir = new File("./");
    private OutputFormat outputFormat = OutputFormat.png;
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable arg0) {
            Thread thread = new Thread(arg0);
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final Pattern DOT_VERSION_PATTERN = Pattern.compile("dot.*\\s+version\\s+(\\S+).*");

    public String execute(String dotFile, String diagramFile) {
        ArrayList<Object> commandList = new ArrayList<Object>();
        try {
            commandList.add(this.getDotExe());
            commandList.add("-T" + this.getOutputFormat());
            commandList.add(dotFile);
            commandList.add("-o" + diagramFile);
            commandList.add("-Tcmapx");
            Process process = Runtime.getRuntime().exec(commandList.toArray(new String[0]), null, this.dir);
            ThreadReader threadReader = new ThreadReader(process.getInputStream());
            ThreadReader errorThreadReader = new ThreadReader(process.getErrorStream());
            Future<?> future1 = this.executorService.submit(threadReader);
            Future<?> future2 = this.executorService.submit(errorThreadReader);
            int ret = process.waitFor();
            if (ret == 0) {
                future1.get();
                return threadReader.getResult();
            }
            future2.get();
            throw new DotCommandException(ret, errorThreadReader.getResult());
        }
        catch (IOException e) {
            throw new DotRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new DotRuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new DotRuntimeException(e);
        }
    }

    public String getVersion() {
        ArrayList<String> commandList = new ArrayList<String>();
        try {
            commandList.add(this.getDotExe());
            commandList.add("-V");
            Process process = Runtime.getRuntime().exec(commandList.toArray(new String[0]));
            ThreadReader threadReader = new ThreadReader(process.getInputStream());
            ThreadReader errorThreadReader = new ThreadReader(process.getErrorStream());
            Future<?> future = this.executorService.submit(threadReader);
            Future<?> futureError = this.executorService.submit(errorThreadReader);
            int ret = process.waitFor();
            if (ret == 0) {
                futureError.get();
                future.cancel(true);
                String version = errorThreadReader.getResult();
                Matcher matcher = DOT_VERSION_PATTERN.matcher(version);
                if (matcher.matches()) {
                    return matcher.group(1);
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            throw new DotRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new DotRuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new DotRuntimeException(e);
        }
    }

    private String getDotExe() {
        if (WIN32) {
            File file = this.getWin32GraphvizPath();
            if (file == null) {
                return this.dot != null ? this.dot : "dot";
            }
            return file.getAbsolutePath();
        }
        return this.dot != null ? this.dot : "dot";
    }

    private File getWin32GraphvizPath() {
        String programFiles = System.getenv("ProgramFiles");
        File programFilesPath = new File(programFiles);
        File graphvizDirecroty = this.getWin32GraphvizDirectoryFromProgramFiles(programFilesPath);
        if (graphvizDirecroty == null) {
            graphvizDirecroty = this.getWin32GraphvizDirectory(programFiles, programFilesPath);
        }
        if (graphvizDirecroty != null) {
            return new File(graphvizDirecroty, "bin" + System.getProperty("file.separator") + "dot.exe");
        }
        return null;
    }

    private File getWin32GraphvizDirectory(String programFiles, File programFilesPath) {
        File programFilesPathParent = programFilesPath.getParentFile();
        File[] programFilesOthers = programFilesPathParent.listFiles(f -> f.isDirectory() && f.getAbsolutePath().startsWith(programFiles + " "));
        if (programFilesOthers == null) {
            return null;
        }
        for (File programFilesOther : programFilesOthers) {
            File graphvizDirecroty = this.getWin32GraphvizDirectoryFromProgramFiles(programFilesOther);
            if (graphvizDirecroty == null) continue;
            return graphvizDirecroty;
        }
        return null;
    }

    private File getWin32GraphvizDirectoryFromProgramFiles(File programFilesPath) {
        Object[] files = programFilesPath.listFiles(f -> f.isDirectory() && f.getName().startsWith("Graphviz"));
        if (CommonUtils.isEmpty((Object)files)) {
            return null;
        }
        Arrays.sort(files);
        return files[files.length - 1];
    }

    public String getDot() {
        return this.dot;
    }

    public void setDot(String dot) {
        this.dot = dot;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    static class ThreadReader
    implements Runnable {
        private final InputStream is;
        private BufferedReader bufReader;
        private StringBuilder builder = new StringBuilder();

        ThreadReader(InputStream is) {
            this.is = is;
            this.bufReader = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.bufReader.readLine()) != null) {
                    this.builder.append(line);
                    this.builder.append(LINE_SEPARATOR);
                }
            }
            catch (IOException e) {
                throw new DotRuntimeException(e);
            }
            finally {
                FileUtils.close((Closeable)this.bufReader);
                FileUtils.close((Closeable)this.is);
            }
        }

        public String getResult() {
            return this.builder.toString();
        }
    }
}

