/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.graphviz.ArrowType;
import com.sqlapp.graphviz.Compass;
import com.sqlapp.graphviz.Edge;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.NodePort;
import com.sqlapp.graphviz.Port;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import java.util.function.BiConsumer;
import lombok.Generated;

public class PartitionParentEdgeBuilder
extends AbstractSchemaGraphBuilder {
    private BiConsumer<ForeignKeyConstraint, Edge> setAttribute = null;

    private PartitionParentEdgeBuilder() {
    }

    public static PartitionParentEdgeBuilder create() {
        PartitionParentEdgeBuilder builder = new PartitionParentEdgeBuilder();
        return builder;
    }

    public void build(Table table, Graph graph) {
        if (table.getPartitionParent() != null) {
            Table parent = table.getPartitionParent().getTable();
            String name = SchemaGraphUtils.getName(table);
            Node tableNode = graph.getNode(name);
            String portName = SchemaGraphUtils.getName(table);
            Port fromPort = tableNode.getPort(portName);
            Node inheritsNode = graph.getNode(SchemaGraphUtils.getName(parent));
            String toPortName = "footer_" + SchemaGraphUtils.getName(parent);
            if (inheritsNode == null) {
                return;
            }
            Port toPort = inheritsNode.getPort(toPortName);
            NodePort nodePort1 = new NodePort(tableNode, fromPort, Compass.North);
            NodePort nodePort2 = new NodePort(inheritsNode, toPort, Compass.South);
            nodePort2 = toPort == null ? new NodePort(inheritsNode, Compass.South) : new NodePort(inheritsNode, toPort, Compass.South);
            Edge edge = graph.addEdge(nodePort1, nodePort2);
            this.setArrow(table, parent, edge);
            edge.setWeight(10);
            edge.setLabel(this.createLabel(table, parent));
        }
    }

    private String createLabel(Table table, Table parent) {
        StringBuilder builder = new StringBuilder();
        builder.append("Partitioning");
        return builder.toString();
    }

    protected void setArrow(Table table, Table parent, Edge edge) {
        edge.setArrowhead(ArrowType.empty);
    }

    protected PartitionParentEdgeBuilder instance() {
        return this;
    }

    @Generated
    public BiConsumer<ForeignKeyConstraint, Edge> setAttribute() {
        return this.setAttribute;
    }

    @Generated
    public PartitionParentEdgeBuilder setAttribute(BiConsumer<ForeignKeyConstraint, Edge> setAttribute) {
        this.setAttribute = setAttribute;
        return this;
    }
}

