/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.graphviz.labeltable.Align;
import com.sqlapp.graphviz.labeltable.TdElement;
import com.sqlapp.graphviz.labeltable.TrElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;

public class TableColumnCellBuilder
extends AbstractSchemaGraphBuilder {
    private String defaultColor = null;
    private String defaultBgcolor = "#A9D0F5";
    private String defaultPkBgcolor = "#81BEF7";
    private Function<Column, String> name = c -> c.getName();
    private Function<Column, String> color = c -> this.defaultColor();
    private Function<Column, String> bgcolor = c -> this.defaultBgcolor();
    private Function<Column, String> pkBgcolor = c -> this.defaultPkBgcolor();
    private boolean createEmptyCell = true;
    private Function<Column, String> notNull = c -> "(NN)";
    private Function<Column, String> identity = c -> "IDENTITY";
    private Function<Column, String> defaultValue = c -> c.getDefaultValue();
    private Function<Column, String> check = c -> c.getCheck();
    private BiFunction<Column, String, String> dataType = (c, type) -> type;
    private int colspan = 1;

    private TableColumnCellBuilder() {
    }

    public static TableColumnCellBuilder create() {
        TableColumnCellBuilder builder = new TableColumnCellBuilder();
        return builder;
    }

    public static TableColumnCellBuilder createSimple() {
        TableColumnCellBuilder builder = new TableColumnCellBuilder();
        builder.createEmptyCell(false);
        builder.dataType((c, type) -> null);
        builder.notNull(c -> null);
        builder.identity(c -> null);
        builder.defaultValue(c -> null);
        builder.check(c -> null);
        return builder;
    }

    public void build(Column column, TrElement tr) {
        this.createHead(column, tr);
        this.createName(column, tr);
        this.createDataType(column, tr);
        this.createNotNull(column, tr);
        this.createIdentity(column, tr);
        this.createDefaultValue(column, tr);
        this.createCheck(column, tr);
        this.createTail(column, tr);
    }

    private TableColumnCellBuilder createHead(Column column, TrElement tr) {
        tr.addCell(cell -> {
            this.setCommonAttribute(column, (TdElement)cell);
            cell.setPort("head_" + SchemaGraphUtils.getName(column));
            cell.setValue("");
        });
        return this.instance();
    }

    private TableColumnCellBuilder createTail(Column column, TrElement tr) {
        tr.addCell(cell -> {
            this.setCommonAttribute(column, (TdElement)cell);
            cell.setPort("tail_" + SchemaGraphUtils.getName(column));
            cell.setValue("");
        });
        return this.instance();
    }

    private TableColumnCellBuilder createName(Column column, TrElement tr) {
        String value = this.name.apply(column);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(column, (TdElement)cell);
                cell.setPort(this.getPortName(column));
                if (column.isForeignKey()) {
                    cell.addFont(font -> {
                        font.setColor("blue");
                        font.setValue(value);
                    });
                } else {
                    cell.setValue(value);
                }
                if (CommonUtils.isEmpty((CharSequence)column.getDisplayRemarks())) {
                    cell.setTooltip(column.getRemarks());
                } else {
                    cell.setTooltip(column.getDisplayRemarks());
                }
            });
        } else {
            this.addEmptyCell(column, tr);
        }
        return this.instance();
    }

    private void addEmptyCell(Column column, TrElement tr) {
        if (this.createEmptyCell) {
            tr.addCell(cell -> {
                this.setCommonAttribute(column, (TdElement)cell);
                cell.setValue("");
            });
        }
    }

    private TableColumnCellBuilder createNotNull(Column column, TrElement tr) {
        String value = this.notNull.apply(column);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(column, (TdElement)cell);
                if (column.isNotNull()) {
                    cell.setValue(value);
                } else {
                    cell.setValue("");
                }
            });
        } else {
            this.addEmptyCell(column, tr);
        }
        return this.instance();
    }

    private TableColumnCellBuilder createDataType(Column column, TrElement tr) {
        Dialect dialect = column.getDialect();
        if (dialect == null) {
            dialect = DialectResolver.getInstance().getDefaultDialect();
        }
        AbstractSqlBuilder sqlBuilder = dialect.createSqlBuilder();
        sqlBuilder.addTypeDefinition(column);
        String type = sqlBuilder.toString();
        String value = this.dataType.apply(column, type);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(column, (TdElement)cell);
                cell.setValue(value);
            });
        } else {
            this.addEmptyCell(column, tr);
        }
        return this.instance();
    }

    private TableColumnCellBuilder createIdentity(Column column, TrElement tr) {
        String value = this.identity.apply(column);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(column, (TdElement)cell);
                if (column.isIdentity()) {
                    cell.setValue(value);
                } else {
                    cell.setValue("");
                }
            });
        } else {
            this.addEmptyCell(column, tr);
        }
        return this.instance();
    }

    private TableColumnCellBuilder createDefaultValue(Column column, TrElement tr) {
        String value = this.defaultValue.apply(column);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(column, (TdElement)cell);
                cell.setValue(value);
            });
        } else {
            this.addEmptyCell(column, tr);
        }
        return this.instance();
    }

    private TableColumnCellBuilder createCheck(Column column, TrElement tr) {
        String value = this.check.apply(column);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(column, (TdElement)cell);
                cell.setValue(value);
            });
        } else {
            this.addEmptyCell(column, tr);
        }
        return this.instance();
    }

    private String getPortName(Column column) {
        return SchemaGraphUtils.getName(column);
    }

    private TableColumnCellBuilder setCommonAttribute(Column column, TdElement cell) {
        cell.setAlign(Align.LEFT);
        cell.setColor(this.getColumnColor(column));
        if (column.isPrimaryKey()) {
            cell.setBgcolor(this.getColumnPkBgcolor(column));
        } else {
            cell.setBgcolor(this.getColumnBgcolor(column));
        }
        return this.instance();
    }

    private TableColumnCellBuilder instance() {
        return this;
    }

    private String getColumnColor(Column column) {
        String value = this.color.apply(column);
        if (value == null) {
            return this.defaultColor();
        }
        return value;
    }

    private String getColumnBgcolor(Column column) {
        String value = this.bgcolor.apply(column);
        if (value == null) {
            return this.defaultBgcolor();
        }
        return value;
    }

    private String getColumnPkBgcolor(Column column) {
        String value = this.pkBgcolor.apply(column);
        if (value == null) {
            return this.defaultBgcolor();
        }
        return value;
    }

    @Generated
    public String defaultColor() {
        return this.defaultColor;
    }

    @Generated
    public String defaultBgcolor() {
        return this.defaultBgcolor;
    }

    @Generated
    public String defaultPkBgcolor() {
        return this.defaultPkBgcolor;
    }

    @Generated
    public Function<Column, String> name() {
        return this.name;
    }

    @Generated
    public Function<Column, String> color() {
        return this.color;
    }

    @Generated
    public Function<Column, String> bgcolor() {
        return this.bgcolor;
    }

    @Generated
    public Function<Column, String> pkBgcolor() {
        return this.pkBgcolor;
    }

    @Generated
    public boolean createEmptyCell() {
        return this.createEmptyCell;
    }

    @Generated
    public Function<Column, String> notNull() {
        return this.notNull;
    }

    @Generated
    public Function<Column, String> identity() {
        return this.identity;
    }

    @Generated
    public Function<Column, String> defaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Function<Column, String> check() {
        return this.check;
    }

    @Generated
    public BiFunction<Column, String, String> dataType() {
        return this.dataType;
    }

    @Generated
    public int colspan() {
        return this.colspan;
    }

    @Generated
    public TableColumnCellBuilder defaultColor(String defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    @Generated
    public TableColumnCellBuilder defaultBgcolor(String defaultBgcolor) {
        this.defaultBgcolor = defaultBgcolor;
        return this;
    }

    @Generated
    public TableColumnCellBuilder defaultPkBgcolor(String defaultPkBgcolor) {
        this.defaultPkBgcolor = defaultPkBgcolor;
        return this;
    }

    @Generated
    public TableColumnCellBuilder name(Function<Column, String> name) {
        this.name = name;
        return this;
    }

    @Generated
    public TableColumnCellBuilder color(Function<Column, String> color) {
        this.color = color;
        return this;
    }

    @Generated
    public TableColumnCellBuilder bgcolor(Function<Column, String> bgcolor) {
        this.bgcolor = bgcolor;
        return this;
    }

    @Generated
    public TableColumnCellBuilder pkBgcolor(Function<Column, String> pkBgcolor) {
        this.pkBgcolor = pkBgcolor;
        return this;
    }

    @Generated
    public TableColumnCellBuilder createEmptyCell(boolean createEmptyCell) {
        this.createEmptyCell = createEmptyCell;
        return this;
    }

    @Generated
    public TableColumnCellBuilder notNull(Function<Column, String> notNull) {
        this.notNull = notNull;
        return this;
    }

    @Generated
    public TableColumnCellBuilder identity(Function<Column, String> identity) {
        this.identity = identity;
        return this;
    }

    @Generated
    public TableColumnCellBuilder defaultValue(Function<Column, String> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Generated
    public TableColumnCellBuilder check(Function<Column, String> check) {
        this.check = check;
        return this;
    }

    @Generated
    public TableColumnCellBuilder dataType(BiFunction<Column, String, String> dataType) {
        this.dataType = dataType;
        return this;
    }

    @Generated
    public TableColumnCellBuilder colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }
}

