/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Statistics;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.StatisticsProperty;
import com.sqlapp.graphviz.labeltable.TableElement;
import com.sqlapp.graphviz.labeltable.TrElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import com.sqlapp.graphviz.schemas.TableColumnCellBuilder;
import com.sqlapp.graphviz.schemas.TableTableHeaderBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;

public class TableLabelBuilder
extends AbstractSchemaGraphBuilder {
    private String defaultColor = null;
    private String defaultBgcolor = "#EFFBFB";
    private Function<Table, String> color = t -> this.defaultColor();
    private Function<Table, String> bgcolor = t -> this.defaultBgcolor();
    private TableTableHeaderBuilder tableTableHeaderBuilder = TableTableHeaderBuilder.create();
    private TableColumnCellBuilder tableColumnCellBuilder = TableColumnCellBuilder.create();
    private BiConsumer<Table, TableElement> setAttribute = null;
    private int colspan = 1;

    private TableLabelBuilder() {
    }

    public static TableLabelBuilder create() {
        TableLabelBuilder builder = new TableLabelBuilder();
        return builder;
    }

    public static TableLabelBuilder createSimple() {
        TableLabelBuilder builder = new TableLabelBuilder();
        builder.tableColumnCellBuilder = TableColumnCellBuilder.createSimple();
        return builder;
    }

    public void build(Table table, TableElement element) {
        String rows;
        element.setCellpadding(0);
        element.setCellspacing(0);
        element.setBorder(0);
        element.setColor(this.color().apply(table));
        element.setBgcolor(this.bgcolor().apply(table));
        if (this.tableTableHeaderBuilder != null) {
            element.addRow(tr -> tr.addCell(cell -> {
                cell.setBorder(1);
                cell.setTable(tableElement -> {
                    tableElement.setCellpadding(1);
                    tableElement.setCellspacing(0);
                    tableElement.setBorder(0);
                    tableElement.addRow(row -> {
                        this.tableTableHeaderBuilder.parent(this);
                        this.tableTableHeaderBuilder.build(table, (TrElement)row);
                    });
                });
            }));
        }
        if (this.tableColumnCellBuilder != null && table.getColumns().size() > 0) {
            element.addRow(tr -> tr.addCell(cell -> {
                cell.setBorder(1);
                cell.setTable(tableElement -> {
                    tableElement.setCellpadding(1);
                    tableElement.setCellspacing(0);
                    tableElement.setBorder(0);
                    for (Column column : table.getColumns()) {
                        if (!this.getDrawOption().getColumnFilter().test((Object)column)) continue;
                        tableElement.addRow(row -> {
                            this.tableColumnCellBuilder.parent(this);
                            this.tableColumnCellBuilder.build(column, (TrElement)row);
                        });
                    }
                });
            }));
        }
        if (!CommonUtils.isEmpty((CharSequence)(rows = Statistics.ROWS.getFormatedValue((StatisticsProperty)table, this.getDrawOption().getLocale())))) {
            element.addRow(tr -> tr.addCell(cell -> {
                cell.setBorder(1);
                cell.setTable(tableElement -> {
                    tableElement.setCellpadding(1);
                    tableElement.setCellspacing(0);
                    tableElement.setBorder(0);
                    tableElement.addRow(row -> row.addCell(td -> td.setValue(rows + " rows")));
                });
            }));
        }
        if (table.getColumns().size() > 0) {
            element.addRow(tr -> tr.addCell(cell -> {
                cell.setBorder(0);
                cell.setTable(tableElement -> {
                    tableElement.setCellpadding(0);
                    tableElement.setCellspacing(0);
                    tableElement.setBorder(0);
                    tableElement.addRow(row -> {
                        row.addCell(td -> td.setValue(""));
                        row.addCell(td -> {
                            td.setValue("");
                            td.setPort("footer_" + SchemaGraphUtils.getName(table));
                        });
                        row.addCell(td -> td.setValue(""));
                    });
                });
            }));
        }
        if (this.setAttribute != null) {
            this.setAttribute.accept(table, element);
        }
    }

    protected TableLabelBuilder instance() {
        return this;
    }

    @Generated
    public String defaultColor() {
        return this.defaultColor;
    }

    @Generated
    public String defaultBgcolor() {
        return this.defaultBgcolor;
    }

    @Generated
    public Function<Table, String> color() {
        return this.color;
    }

    @Generated
    public Function<Table, String> bgcolor() {
        return this.bgcolor;
    }

    @Generated
    public TableTableHeaderBuilder tableTableHeaderBuilder() {
        return this.tableTableHeaderBuilder;
    }

    @Generated
    public TableColumnCellBuilder tableColumnCellBuilder() {
        return this.tableColumnCellBuilder;
    }

    @Generated
    public BiConsumer<Table, TableElement> setAttribute() {
        return this.setAttribute;
    }

    @Generated
    public int colspan() {
        return this.colspan;
    }

    @Generated
    public TableLabelBuilder defaultColor(String defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    @Generated
    public TableLabelBuilder defaultBgcolor(String defaultBgcolor) {
        this.defaultBgcolor = defaultBgcolor;
        return this;
    }

    @Generated
    public TableLabelBuilder color(Function<Table, String> color) {
        this.color = color;
        return this;
    }

    @Generated
    public TableLabelBuilder bgcolor(Function<Table, String> bgcolor) {
        this.bgcolor = bgcolor;
        return this;
    }

    @Generated
    public TableLabelBuilder tableTableHeaderBuilder(TableTableHeaderBuilder tableTableHeaderBuilder) {
        this.tableTableHeaderBuilder = tableTableHeaderBuilder;
        return this;
    }

    @Generated
    public TableLabelBuilder tableColumnCellBuilder(TableColumnCellBuilder tableColumnCellBuilder) {
        this.tableColumnCellBuilder = tableColumnCellBuilder;
        return this;
    }

    @Generated
    public TableLabelBuilder setAttribute(BiConsumer<Table, TableElement> setAttribute) {
        this.setAttribute = setAttribute;
        return this;
    }

    @Generated
    public TableLabelBuilder colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }
}

