/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Table;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.labeltable.TableElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import com.sqlapp.graphviz.schemas.TableLabelBuilder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;

public class TableNodeBuilder
extends AbstractSchemaGraphBuilder {
    private Function<Table, TableLabelBuilder> labelBuilder = table -> TableLabelBuilder.create();
    private BiConsumer<Table, Node> setAttribute = null;

    private TableNodeBuilder() {
    }

    public static TableNodeBuilder create() {
        TableNodeBuilder builder = new TableNodeBuilder();
        return builder;
    }

    public Node build(Table table, Graph graph) {
        TableLabelBuilder tableLabelBuilder = this.labelBuilder.apply(table);
        tableLabelBuilder.parent(this);
        Node node = graph.addNode(SchemaGraphUtils.getName(table));
        node.setFontname(this.getDrawOption().getFont());
        node.setFontsize(this.getDrawOption().getNodeFontsize());
        node.setUrl("tables/" + SchemaGraphUtils.getName(table) + ".html");
        node.setHtmlLabel(tableElement -> tableLabelBuilder.build(table, (TableElement)tableElement));
        if (this.setAttribute != null) {
            this.setAttribute.accept(table, node);
        }
        node.set_context(table);
        return node;
    }

    protected TableNodeBuilder instance() {
        return this;
    }

    public TableNodeBuilder labelBuilder(Function<Table, TableLabelBuilder> labelBuilder) {
        this.labelBuilder = labelBuilder;
        return this;
    }

    public TableNodeBuilder labelBuilder(TableLabelBuilder lableBuilder) {
        this.labelBuilder = table -> lableBuilder;
        return this;
    }

    @Generated
    public Function<Table, TableLabelBuilder> labelBuilder() {
        return this.labelBuilder;
    }

    @Generated
    public BiConsumer<Table, Node> setAttribute() {
        return this.setAttribute;
    }

    @Generated
    public TableNodeBuilder setAttribute(BiConsumer<Table, Node> setAttribute) {
        this.setAttribute = setAttribute;
        return this;
    }
}

