/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractGraphVizElement;
import com.sqlapp.graphviz.BrewerColorScheme;
import com.sqlapp.graphviz.Color;
import com.sqlapp.graphviz.GraphStringBuilder;
import com.sqlapp.graphviz.Props;
import com.sqlapp.graphviz.ToGraphStringBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Map;

public abstract class AbstractCommonElement<T extends AbstractCommonElement<?>>
extends AbstractGraphVizElement
implements ToGraphStringBuilder {
    private String label = null;
    @Props(value="URL")
    private String url = null;
    @Props
    private BrewerColorScheme colorscheme = null;
    @Props
    private Color fontcolor = null;
    @Props
    private String fontname = null;
    @Props
    private Double fontsize = null;
    @Props
    private String href;
    @Props
    private String id;
    @Props
    private Boolean nojustify;
    @Props
    private String style;
    @Props
    private String target;
    private Object _context = null;

    public String toString() {
        GraphStringBuilder builder = this.toGraphStringBuilder();
        return builder.toString();
    }

    @Override
    public GraphStringBuilder toGraphStringBuilder() {
        GraphStringBuilder builder = this.createGraphStringBuilder();
        this.initializeProperties(builder);
        return builder;
    }

    private void initializeProperties(GraphStringBuilder builder) {
        Map<String, Object> props = this.getProperties();
        props.forEach((k, v) -> builder.put((String)k, v));
        this.initializeLabel(builder);
    }

    protected void initializeLabel(GraphStringBuilder builder) {
        builder.put("label", this.getLabel());
    }

    protected Map<String, Object> getProperties() {
        Map props = CommonUtils.linkedMap();
        this.put(props, "colorscheme", (Object)this.colorscheme);
        this.put(props, "fontcolor", (Object)this.fontcolor);
        this.put(props, "fontname", this.fontname);
        this.put(props, "fontsize", this.fontsize);
        this.put(props, "href", this.href);
        this.put(props, "id", this.id);
        this.put(props, "nojustify", this.nojustify);
        this.put(props, "URL", this.url);
        this.put(props, "style", this.style);
        this.put(props, "target", this.target);
        return props;
    }

    protected void put(Map<String, Object> props, String name, Object value) {
        if (value != null) {
            props.put(name, value);
        }
    }

    protected abstract GraphStringBuilder createGraphStringBuilder();

    @Props
    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label;
    }

    public T setLabel(String label) {
        this.label = label;
        return this.instance();
    }

    public T setColorscheme(BrewerColorScheme colorScheme) {
        this.colorscheme = colorScheme;
        return this.instance();
    }

    protected T instance() {
        return (T)this;
    }

    public T setFontsize(int size) {
        this.fontsize = 0.0 + (double)size;
        return this.instance();
    }

    public T setFontsize(double size) {
        this.fontsize = size;
        return this.instance();
    }

    public T setFontsize(Number size) {
        if (size != null) {
            return this.setFontsize(size.doubleValue());
        }
        return this.instance();
    }

    public <S> S get_context() {
        return (S)this._context;
    }

    public String getUrl() {
        return this.url;
    }

    public BrewerColorScheme getColorscheme() {
        return this.colorscheme;
    }

    public Color getFontcolor() {
        return this.fontcolor;
    }

    public String getFontname() {
        return this.fontname;
    }

    public Double getFontsize() {
        return this.fontsize;
    }

    public String getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getNojustify() {
        return this.nojustify;
    }

    public String getStyle() {
        return this.style;
    }

    public String getTarget() {
        return this.target;
    }

    public AbstractCommonElement<T> setUrl(String url) {
        this.url = url;
        return this;
    }

    public AbstractCommonElement<T> setFontcolor(Color fontcolor) {
        this.fontcolor = fontcolor;
        return this;
    }

    public AbstractCommonElement<T> setFontname(String fontname) {
        this.fontname = fontname;
        return this;
    }

    public AbstractCommonElement<T> setHref(String href) {
        this.href = href;
        return this;
    }

    public AbstractCommonElement<T> setId(String id) {
        this.id = id;
        return this;
    }

    public AbstractCommonElement<T> setNojustify(Boolean nojustify) {
        this.nojustify = nojustify;
        return this;
    }

    public AbstractCommonElement<T> setStyle(String style) {
        this.style = style;
        return this;
    }

    public AbstractCommonElement<T> setTarget(String target) {
        this.target = target;
        return this;
    }

    public AbstractCommonElement<T> set_context(Object _context) {
        this._context = _context;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCommonElement)) {
            return false;
        }
        AbstractCommonElement other = (AbstractCommonElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        BrewerColorScheme this$colorscheme = this.getColorscheme();
        BrewerColorScheme other$colorscheme = other.getColorscheme();
        if (this$colorscheme == null ? other$colorscheme != null : !((Object)((Object)this$colorscheme)).equals((Object)other$colorscheme)) {
            return false;
        }
        Color this$fontcolor = this.getFontcolor();
        Color other$fontcolor = other.getFontcolor();
        if (this$fontcolor == null ? other$fontcolor != null : !((Object)((Object)this$fontcolor)).equals((Object)other$fontcolor)) {
            return false;
        }
        String this$fontname = this.getFontname();
        String other$fontname = other.getFontname();
        if (this$fontname == null ? other$fontname != null : !this$fontname.equals(other$fontname)) {
            return false;
        }
        Double this$fontsize = this.getFontsize();
        Double other$fontsize = other.getFontsize();
        if (this$fontsize == null ? other$fontsize != null : !((Object)this$fontsize).equals(other$fontsize)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$nojustify = this.getNojustify();
        Boolean other$nojustify = other.getNojustify();
        if (this$nojustify == null ? other$nojustify != null : !((Object)this$nojustify).equals(other$nojustify)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        Object this$_context = this.get_context();
        Object other$_context = other.get_context();
        return !(this$_context == null ? other$_context != null : !this$_context.equals(other$_context));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractCommonElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        BrewerColorScheme $colorscheme = this.getColorscheme();
        result = result * 59 + ($colorscheme == null ? 43 : ((Object)((Object)$colorscheme)).hashCode());
        Color $fontcolor = this.getFontcolor();
        result = result * 59 + ($fontcolor == null ? 43 : ((Object)((Object)$fontcolor)).hashCode());
        String $fontname = this.getFontname();
        result = result * 59 + ($fontname == null ? 43 : $fontname.hashCode());
        Double $fontsize = this.getFontsize();
        result = result * 59 + ($fontsize == null ? 43 : ((Object)$fontsize).hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $nojustify = this.getNojustify();
        result = result * 59 + ($nojustify == null ? 43 : ((Object)$nojustify).hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        Object $_context = this.get_context();
        result = result * 59 + ($_context == null ? 43 : $_context.hashCode());
        return result;
    }
}

