/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.graphviz.Compass;
import com.sqlapp.graphviz.Edge;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.NodePort;
import com.sqlapp.graphviz.Port;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import java.util.function.BiConsumer;

public class ForeignKeyConstraintEdgeBuilder
extends AbstractSchemaGraphBuilder {
    private BiConsumer<ForeignKeyConstraint, Edge> setAttribute = null;

    private ForeignKeyConstraintEdgeBuilder() {
    }

    public static ForeignKeyConstraintEdgeBuilder create() {
        ForeignKeyConstraintEdgeBuilder builder = new ForeignKeyConstraintEdgeBuilder();
        return builder;
    }

    public void build(ForeignKeyConstraint fk, Graph graph) {
        Table table = fk.getTable();
        Table pkTable = fk.getRelatedTable();
        Node fkNode = graph.getNode(SchemaGraphUtils.getName(table));
        String fkPortName = "head_" + SchemaGraphUtils.getFkPortName(fk);
        Port fkPort = fkNode.getPort(fkPortName);
        Node pkNode = graph.getNode(SchemaGraphUtils.getName(pkTable));
        if (pkNode == null) {
            return;
        }
        String pkPortName = "tail_" + SchemaGraphUtils.getPkPortName(fk);
        Port pkPort = pkNode.getPort(pkPortName);
        NodePort nodePort1 = new NodePort(fkNode, fkPort, Compass.West);
        NodePort nodePort2 = new NodePort(pkNode, pkPort);
        Edge edge = graph.addEdge(nodePort1, nodePort2);
        this.setArrow(fk, edge);
        edge.setLabel(this.createLabel(fk));
        edge.setComment(fk.getName());
        edge.setFontsize(this.getDrawOption().getEdgeFontsize());
        if (this.setAttribute != null) {
            this.setAttribute.accept(fk, edge);
        }
    }

    protected void setArrow(ForeignKeyConstraint fk, Edge edge) {
        this.getDrawOption().getErDrawMethod().draw(fk, edge);
    }

    private String createLabel(ForeignKeyConstraint fk) {
        StringBuilder builder = new StringBuilder();
        if (this.getDrawOption().isWithRelationName()) {
            builder.append(fk.getName());
        }
        if (!this.getDrawOption().isWithRelationCascadeOption()) {
            return builder.toString();
        }
        StringBuilder cascBuilder = new StringBuilder();
        if (fk.getDeleteRule() != null && !fk.getDeleteRule().isRestrict()) {
            if (this.getDrawOption().isWithRelationName()) {
                cascBuilder.append("\n");
            }
            cascBuilder.append("(");
            cascBuilder.append("DEL=");
            cascBuilder.append(fk.getDeleteRule().getAbbrName());
        }
        if (fk.getUpdateRule() != null && !fk.getUpdateRule().isRestrict()) {
            if (cascBuilder.length() > 0) {
                cascBuilder.append(",");
            } else {
                if (this.getDrawOption().isWithRelationName()) {
                    cascBuilder.append("\n");
                }
                cascBuilder.append("(");
            }
            cascBuilder.append("UPD=");
            cascBuilder.append(fk.getUpdateRule().getAbbrName());
        }
        if (cascBuilder.length() > 0) {
            cascBuilder.append(")");
            builder.append(cascBuilder.toString());
        }
        if (fk.isVirtual()) {
            if (cascBuilder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Virtual");
        }
        return builder.toString();
    }

    protected ForeignKeyConstraintEdgeBuilder instance() {
        return this;
    }

    public BiConsumer<ForeignKeyConstraint, Edge> setAttribute() {
        return this.setAttribute;
    }

    public ForeignKeyConstraintEdgeBuilder setAttribute(BiConsumer<ForeignKeyConstraint, Edge> setAttribute) {
        this.setAttribute = setAttribute;
        return this;
    }
}

