/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.graphviz.Color;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.NodeShape;
import com.sqlapp.graphviz.RankType;
import com.sqlapp.graphviz.Rankdir;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.ForeignKeyConstraintEdgeBuilder;
import com.sqlapp.graphviz.schemas.InheritsEdgeBuilder;
import com.sqlapp.graphviz.schemas.TableNodeBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaGraphBuilder
extends AbstractSchemaGraphBuilder {
    private TableNodeBuilder tableNodeBuilder = TableNodeBuilder.create();
    private ForeignKeyConstraintEdgeBuilder foreignKeyConstraintEdgeBuilder = ForeignKeyConstraintEdgeBuilder.create();
    private InheritsEdgeBuilder inheritsEdgeBuilder = InheritsEdgeBuilder.create();

    public static SchemaGraphBuilder create() {
        SchemaGraphBuilder builder = new SchemaGraphBuilder();
        return builder;
    }

    public Graph createGraph(String name) {
        Graph graph = new Graph(name);
        graph.setDirected(true);
        graph.addGraphSetting(setting -> {
            setting.setNodesep(0.1);
            setting.setFontname(this.getDrawOption().getFont());
            setting.setFontsize(11);
            setting.setRankdir(Rankdir.RightToLeft);
            setting.setBgcolor(Color.transparent);
        });
        return graph;
    }

    public void create(Schema schema, Graph parentGraph) {
        if (!this.getDrawOption().getSchemaFilter().test(schema)) {
            return;
        }
        List<Table> relationTables = this.relationTables((Collection<Table>)schema.getTables());
        Graph graph = this.createGraph(schema.getName());
        graph.setLabel(schema.getName());
        graph.setCluster(true);
        parentGraph.addGraph(graph);
        graph.addNodeSetting(setting -> {
            setting.setShape(NodeShape.plaintext);
            setting.setFontsize(11);
        });
        List nodes = CommonUtils.list();
        schema.getTables().forEach(table -> {
            if (!this.getDrawOption().getTableFilter().test(table)) {
                return;
            }
            this.tableNodeBuilder.parent(this);
            Node node = this.tableNodeBuilder.build((Table)table, graph);
            nodes.add(node);
        });
        if (relationTables.size() == 0) {
            this.addRank(nodes, graph);
        } else {
            schema.getTables().forEach(table -> {
                if (!this.getDrawOption().getTableFilter().test(table)) {
                    return;
                }
                this.inheritsEdgeBuilder.parent(this);
                this.inheritsEdgeBuilder.build((Table)table, graph);
                this.foreignKeyConstraintEdgeBuilder.parent(this);
                table.getConstraints().getForeignKeyConstraints().forEach(fk -> this.foreignKeyConstraintEdgeBuilder.build((ForeignKeyConstraint)fk, graph));
            });
        }
    }

    private void addRank(List<Node> nodes, Graph graph) {
        List sameNodes = CommonUtils.list();
        for (Node node : nodes) {
            sameNodes.add(node);
            if (sameNodes.size() <= 4) continue;
            graph.addRank(RankType.same, sameNodes);
            sameNodes.clear();
        }
        if (sameNodes.size() > 1) {
            graph.addRank(RankType.same, sameNodes);
        }
    }

    private List<Table> relationTables(Collection<Table> tables) {
        return tables.stream().filter(table -> this.getDrawOption().getTableFilter().test(table)).filter(table -> table.getChildRelations().size() > 0 || table.getConstraints().getForeignKeyConstraints().size() > 0).collect(Collectors.toList());
    }

    public void create(Collection<Table> tables, Graph graph) {
        graph.addNodeSetting(setting -> {
            setting.setShape(NodeShape.plaintext);
            setting.setFontsize(11);
        });
        List nodes = CommonUtils.list();
        tables.forEach(table -> {
            if (!this.getDrawOption().getTableFilter().test(table)) {
                return;
            }
            this.tableNodeBuilder.parent(this);
            Node node = this.tableNodeBuilder.build((Table)table, graph);
            nodes.add(node);
        });
        List<Table> relationTables = this.relationTables(tables);
        if (relationTables.size() == 0) {
            this.addRank(nodes, graph);
        } else {
            tables.forEach(table -> {
                if (!this.getDrawOption().getTableFilter().test(table)) {
                    return;
                }
                this.inheritsEdgeBuilder.parent(this);
                this.inheritsEdgeBuilder.build((Table)table, graph);
                this.foreignKeyConstraintEdgeBuilder.parent(this);
                table.getConstraints().getForeignKeyConstraints().forEach(fk -> this.foreignKeyConstraintEdgeBuilder.build((ForeignKeyConstraint)fk, graph));
            });
        }
    }

    public TableNodeBuilder tableNodeBuilder() {
        return this.tableNodeBuilder;
    }

    public ForeignKeyConstraintEdgeBuilder foreignKeyConstraintEdgeBuilder() {
        return this.foreignKeyConstraintEdgeBuilder;
    }

    public InheritsEdgeBuilder inheritsEdgeBuilder() {
        return this.inheritsEdgeBuilder;
    }

    public SchemaGraphBuilder tableNodeBuilder(TableNodeBuilder tableNodeBuilder) {
        this.tableNodeBuilder = tableNodeBuilder;
        return this;
    }

    public SchemaGraphBuilder foreignKeyConstraintEdgeBuilder(ForeignKeyConstraintEdgeBuilder foreignKeyConstraintEdgeBuilder) {
        this.foreignKeyConstraintEdgeBuilder = foreignKeyConstraintEdgeBuilder;
        return this;
    }

    public SchemaGraphBuilder inheritsEdgeBuilder(InheritsEdgeBuilder inheritsEdgeBuilder) {
        this.inheritsEdgeBuilder = inheritsEdgeBuilder;
        return this;
    }
}

