/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaUtils;

public class SchemaGraphUtils {
    public static String getName(AbstractSchemaObject<?> object) {
        StringBuilder builder = new StringBuilder();
        Schema schema = SchemaUtils.getSchema(object);
        if (schema != null && schema.getName() != null) {
            builder.append(schema.getName());
            builder.append("_");
        }
        builder.append(object.getName());
        return builder.toString();
    }

    public static String getName(AbstractNamedObject<?> object) {
        StringBuilder builder = new StringBuilder();
        builder.append(object.getName());
        return builder.toString();
    }

    public static String getName(Column column) {
        StringBuilder builder = new StringBuilder();
        String tableName = column.getTableName();
        if (tableName != null) {
            String schemaName = column.getSchemaName();
            if (schemaName != null) {
                builder.append(schemaName);
                builder.append(".");
            }
            builder.append(tableName);
            builder.append(".");
        }
        builder.append(column.getName());
        return builder.toString();
    }

    public static String getName(ReferenceColumn column) {
        StringBuilder builder = new StringBuilder();
        String tableName = column.getTableName();
        if (tableName != null) {
            String schemaName = column.getSchemaName();
            if (schemaName != null) {
                builder.append(schemaName);
                builder.append(".");
            }
            builder.append(tableName);
            builder.append(".");
        }
        builder.append(column.getName());
        return builder.toString();
    }

    public static String getColumnName(String schemaName, String tableName, String columnName) {
        StringBuilder builder = new StringBuilder();
        if (tableName != null) {
            if (schemaName != null) {
                builder.append(schemaName);
                builder.append(".");
            }
            builder.append(tableName);
            builder.append(".");
        }
        builder.append(columnName);
        return builder.toString();
    }

    public static String getPortName(Column column) {
        return SchemaGraphUtils.getName(column);
    }

    public static String getPortName(ReferenceColumn column) {
        return SchemaGraphUtils.getName(column);
    }

    public static String getFkPortName(ForeignKeyConstraint fk) {
        Column column = null;
        column = fk.getColumns().length == 1 ? fk.getColumns()[0] : fk.getColumns()[fk.getColumns().length / 2];
        return SchemaGraphUtils.getPortName(column);
    }

    public static String getPkPortName(ForeignKeyConstraint fk) {
        ReferenceColumn column = null;
        column = fk.getRelatedColumns().size() == 1 ? (ReferenceColumn)fk.getRelatedColumns().get(0) : (ReferenceColumn)fk.getRelatedColumns().get(fk.getRelatedColumns().size() / 2);
        return SchemaGraphUtils.getColumnName(fk.getRelatedTableSchemaName(), fk.getRelatedTableName(), column.getName());
    }
}

