/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Table;
import com.sqlapp.graphviz.labeltable.Align;
import com.sqlapp.graphviz.labeltable.TdElement;
import com.sqlapp.graphviz.labeltable.TrElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import com.sqlapp.util.CommonUtils;
import java.util.function.Function;

public class TableTableHeaderBuilder
extends AbstractSchemaGraphBuilder {
    private int cellSize = 0;
    private String defaultColor = null;
    private String defaultBgcolor = "#58ACFA";
    private Function<Table, String> name = t -> t.getName();
    private Function<Table, String> color = t -> this.defaultColor();
    private Function<Table, String> bgcolor = t -> this.defaultBgcolor();
    private int colspan = 1;

    private TableTableHeaderBuilder() {
    }

    public static TableTableHeaderBuilder create() {
        TableTableHeaderBuilder builder = new TableTableHeaderBuilder();
        return builder;
    }

    public int build(Table table, TrElement tr) {
        this.createName(table, tr);
        return this.cellSize;
    }

    private TableTableHeaderBuilder createName(Table table, TrElement tr) {
        String value = this.name.apply(table);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(table, (TdElement)cell);
                cell.setAlign(Align.CENTER);
                cell.setPort(this.getPortName(table));
                cell.setValue(value);
                if (CommonUtils.isEmpty((CharSequence)table.getDisplayRemarks())) {
                    cell.setTooltip(table.getRemarks());
                } else {
                    cell.setTooltip(table.getDisplayRemarks());
                }
            });
            this.addCellSize();
        }
        return this.instance();
    }

    private String getPortName(Table table) {
        return SchemaGraphUtils.getName(table);
    }

    private TableTableHeaderBuilder setCommonAttribute(Table table, TdElement cell) {
        cell.setAlign(Align.CENTER);
        cell.setColor(this.getTableColor(table));
        cell.setBgcolor(this.getTableBgcolor(table));
        if (this.colspan > 1) {
            cell.setColspan(this.colspan);
        }
        return this.instance();
    }

    private TableTableHeaderBuilder instance() {
        return this;
    }

    private String getTableColor(Table table) {
        String value = this.color.apply(table);
        if (value == null) {
            return this.defaultColor();
        }
        return value;
    }

    private String getTableBgcolor(Table table) {
        String value = this.bgcolor.apply(table);
        if (value == null) {
            return this.defaultBgcolor();
        }
        return value;
    }

    private void addCellSize() {
        this.cellSize += this.colspan;
    }

    public int cellSize() {
        return this.cellSize;
    }

    public String defaultColor() {
        return this.defaultColor;
    }

    public String defaultBgcolor() {
        return this.defaultBgcolor;
    }

    public Function<Table, String> name() {
        return this.name;
    }

    public Function<Table, String> color() {
        return this.color;
    }

    public Function<Table, String> bgcolor() {
        return this.bgcolor;
    }

    public int colspan() {
        return this.colspan;
    }

    public TableTableHeaderBuilder cellSize(int cellSize) {
        this.cellSize = cellSize;
        return this;
    }

    public TableTableHeaderBuilder defaultColor(String defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    public TableTableHeaderBuilder defaultBgcolor(String defaultBgcolor) {
        this.defaultBgcolor = defaultBgcolor;
        return this;
    }

    public TableTableHeaderBuilder name(Function<Table, String> name) {
        this.name = name;
        return this;
    }

    public TableTableHeaderBuilder color(Function<Table, String> color) {
        this.color = color;
        return this;
    }

    public TableTableHeaderBuilder bgcolor(Function<Table, String> bgcolor) {
        this.bgcolor = bgcolor;
        return this;
    }

    public TableTableHeaderBuilder colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }
}

