/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractGraphVizElement;
import com.sqlapp.graphviz.GraphStringBuilder;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.RankCollection;
import com.sqlapp.graphviz.RankType;
import com.sqlapp.graphviz.ToGraphStringBuilder;
import java.util.Arrays;

public class Rank
extends AbstractGraphVizElement
implements ToGraphStringBuilder {
    private final RankType rank;
    private final Node[] nodes;
    private RankCollection parent;

    public Rank(RankType rank, Node ... nodes) {
        this.rank = rank;
        this.nodes = nodes;
    }

    public Rank(Node ... nodes) {
        this.rank = RankType.same;
        this.nodes = nodes;
    }

    public String toString() {
        if (this.isEmpty()) {
            return null;
        }
        GraphStringBuilder builder = this.toGraphStringBuilder();
        return builder.toString();
    }

    @Override
    public GraphStringBuilder toGraphStringBuilder() {
        GraphStringBuilder builder = this.createGraphStringBuilder();
        builder.putNoEscape("rank", this.getRankValue());
        return builder;
    }

    public boolean isEmpty() {
        return this.nodes == null || this.nodes.length == 0;
    }

    protected GraphStringBuilder createGraphStringBuilder() {
        GraphStringBuilder builder = new GraphStringBuilder("");
        builder.setOpen("{").setClose("}");
        builder.setWithLineBreak(false);
        return builder;
    }

    private String getRankValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rank);
        for (Node node : this.nodes) {
            builder.append("; ");
            builder.append(node.getEscapedName());
        }
        return builder.toString();
    }

    public RankType getRank() {
        return this.rank;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rank)) {
            return false;
        }
        Rank other = (Rank)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RankType this$rank = this.getRank();
        RankType other$rank = other.getRank();
        if (this$rank == null ? other$rank != null : !this$rank.equals(other$rank)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNodes(), other.getNodes())) {
            return false;
        }
        RankCollection this$parent = this.getParent();
        RankCollection other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Rank;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RankType $rank = this.getRank();
        result = result * 59 + ($rank == null ? 43 : $rank.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodes());
        RankCollection $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        return result;
    }

    protected RankCollection getParent() {
        return this.parent;
    }

    protected void setParent(RankCollection parent) {
        this.parent = parent;
    }
}

