/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.labeltable;

import com.sqlapp.graphviz.labeltable.AbstractHtmlElement;
import com.sqlapp.graphviz.labeltable.BrElement;
import com.sqlapp.graphviz.labeltable.CharactersElement;
import com.sqlapp.graphviz.labeltable.FontElement;
import com.sqlapp.graphviz.labeltable.HrElement;
import com.sqlapp.graphviz.labeltable.ImgElement;
import com.sqlapp.graphviz.labeltable.VrElement;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractHasChildrenHtmlElement<T extends AbstractHasChildrenHtmlElement<?>>
extends AbstractHtmlElement {
    private List<AbstractHtmlElement> children = CommonUtils.list();

    protected List<AbstractHtmlElement> getChildren() {
        return this.children;
    }

    protected void clearChildren() {
        this.children.forEach(c -> c.setParent(null));
        this.children.clear();
    }

    protected void appenChild(AbstractHtmlElement element) {
        this.getChildren().add(element);
        element.setParent(this);
    }

    public T setValue(String value) {
        CharactersElement element = new CharactersElement(value);
        this.clearChildren();
        this.appenChild(element);
        return this.instance();
    }

    public T addCharacters(String value) {
        CharactersElement element = new CharactersElement(value);
        this.appenChild(element);
        return this.instance();
    }

    public T addFont(Consumer<FontElement> c) {
        FontElement element = new FontElement();
        this.appenChild(element);
        c.accept(element);
        return this.instance();
    }

    public T addBr(Consumer<BrElement> c) {
        BrElement element = new BrElement();
        this.appenChild(element);
        c.accept(element);
        return this.instance();
    }

    public T addBr() {
        BrElement element = new BrElement();
        this.appenChild(element);
        return this.instance();
    }

    public T addImg(Consumer<ImgElement> c) {
        ImgElement element = new ImgElement();
        this.appenChild(element);
        c.accept(element);
        return this.instance();
    }

    public T addVr(Consumer<VrElement> c) {
        VrElement element = new VrElement();
        this.appenChild(element);
        c.accept(element);
        return this.instance();
    }

    public T addHr(Consumer<HrElement> c) {
        HrElement element = new HrElement();
        this.appenChild(element);
        c.accept(element);
        return this.instance();
    }

    protected T instance() {
        return (T)this;
    }
}

