/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Partition;
import com.sqlapp.data.schemas.Statistics;
import com.sqlapp.data.schemas.properties.StatisticsProperty;
import com.sqlapp.graphviz.labeltable.TableElement;
import com.sqlapp.graphviz.labeltable.TrElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.PartitionDetailCellBuilder;
import com.sqlapp.graphviz.schemas.PartitionTableHeaderBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import com.sqlapp.util.CommonUtils;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PartitionLabelBuilder
extends AbstractSchemaGraphBuilder {
    private String defaultColor = null;
    private String defaultBgcolor = "#EFFBFB";
    private Function<Partition, String> color = t -> this.defaultColor();
    private Function<Partition, String> bgcolor = t -> this.defaultBgcolor();
    private PartitionTableHeaderBuilder partitionTableHeaderBuilder = PartitionTableHeaderBuilder.create();
    private PartitionDetailCellBuilder partitionDetailCellBuilder = PartitionDetailCellBuilder.create();
    private BiConsumer<Partition, TableElement> setAttribute = null;
    private int colspan = 1;

    private PartitionLabelBuilder() {
    }

    public static PartitionLabelBuilder create() {
        PartitionLabelBuilder builder = new PartitionLabelBuilder();
        return builder;
    }

    public static PartitionLabelBuilder createSimple() {
        PartitionLabelBuilder builder = new PartitionLabelBuilder();
        builder.partitionDetailCellBuilder = PartitionDetailCellBuilder.createSimple();
        return builder;
    }

    public void build(Partition partition, TableElement element) {
        String rows;
        element.setCellpadding(0);
        element.setCellspacing(0);
        element.setBorder(0);
        element.setColor(this.color().apply(partition));
        element.setBgcolor(this.bgcolor().apply(partition));
        element.addRow(tr -> tr.addCell(cell -> {
            cell.setBorder(1);
            cell.setTable(tableElement -> {
                tableElement.setCellpadding(1);
                tableElement.setCellspacing(0);
                tableElement.setBorder(0);
                tableElement.addRow(row -> {
                    this.partitionTableHeaderBuilder.parent(this);
                    this.partitionTableHeaderBuilder.build(partition, (TrElement)row);
                });
            });
        }));
        if (this.partitionDetailCellBuilder != null) {
            element.addRow(tr -> tr.addCell(cell -> {
                cell.setBorder(1);
                cell.setTable(tableElement -> {
                    tableElement.setCellpadding(1);
                    tableElement.setCellspacing(0);
                    tableElement.setBorder(0);
                    tableElement.addRow(row -> {
                        this.partitionDetailCellBuilder.parent(this);
                        this.partitionDetailCellBuilder.build(partition, (TrElement)row);
                    });
                });
            }));
        }
        if (!CommonUtils.isEmpty((CharSequence)(rows = Statistics.ROWS.getFormatedValue((StatisticsProperty)partition, this.getDrawOption().getLocale())))) {
            element.addRow(tr -> tr.addCell(cell -> {
                cell.setBorder(1);
                cell.setTable(tableElement -> {
                    tableElement.setCellpadding(1);
                    tableElement.setCellspacing(0);
                    tableElement.setBorder(0);
                    tableElement.addRow(row -> row.addCell(td -> td.setValue(rows + " rows")));
                });
            }));
        }
        element.addRow(tr -> tr.addCell(cell -> {
            cell.setBorder(0);
            cell.setTable(tableElement -> {
                tableElement.setCellpadding(0);
                tableElement.setCellspacing(0);
                tableElement.setBorder(0);
                tableElement.addRow(row -> {
                    row.addCell(td -> td.setValue(""));
                    row.addCell(td -> {
                        td.setValue("");
                        td.setPort("footer_" + SchemaGraphUtils.getName(partition));
                    });
                    row.addCell(td -> td.setValue(""));
                });
            });
        }));
        if (this.setAttribute != null) {
            this.setAttribute.accept(partition, element);
        }
    }

    protected PartitionLabelBuilder instance() {
        return this;
    }

    public String defaultColor() {
        return this.defaultColor;
    }

    public String defaultBgcolor() {
        return this.defaultBgcolor;
    }

    public Function<Partition, String> color() {
        return this.color;
    }

    public Function<Partition, String> bgcolor() {
        return this.bgcolor;
    }

    public PartitionTableHeaderBuilder partitionTableHeaderBuilder() {
        return this.partitionTableHeaderBuilder;
    }

    public PartitionDetailCellBuilder partitionDetailCellBuilder() {
        return this.partitionDetailCellBuilder;
    }

    public BiConsumer<Partition, TableElement> setAttribute() {
        return this.setAttribute;
    }

    public int colspan() {
        return this.colspan;
    }

    public PartitionLabelBuilder defaultColor(String defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    public PartitionLabelBuilder defaultBgcolor(String defaultBgcolor) {
        this.defaultBgcolor = defaultBgcolor;
        return this;
    }

    public PartitionLabelBuilder color(Function<Partition, String> color) {
        this.color = color;
        return this;
    }

    public PartitionLabelBuilder bgcolor(Function<Partition, String> bgcolor) {
        this.bgcolor = bgcolor;
        return this;
    }

    public PartitionLabelBuilder partitionTableHeaderBuilder(PartitionTableHeaderBuilder partitionTableHeaderBuilder) {
        this.partitionTableHeaderBuilder = partitionTableHeaderBuilder;
        return this;
    }

    public PartitionLabelBuilder partitionDetailCellBuilder(PartitionDetailCellBuilder partitionDetailCellBuilder) {
        this.partitionDetailCellBuilder = partitionDetailCellBuilder;
        return this;
    }

    public PartitionLabelBuilder setAttribute(BiConsumer<Partition, TableElement> setAttribute) {
        this.setAttribute = setAttribute;
        return this;
    }

    public PartitionLabelBuilder colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }
}

