/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Partition;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.labeltable.TableElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import com.sqlapp.graphviz.schemas.PartitionLabelBuilder;
import com.sqlapp.graphviz.schemas.SchemaGraphUtils;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PartitionNodeBuilder
extends AbstractSchemaGraphBuilder {
    private Function<Partition, PartitionLabelBuilder> labelBuilder = partition -> PartitionLabelBuilder.create();
    private BiConsumer<Partition, Node> setAttribute = null;

    private PartitionNodeBuilder() {
    }

    public static PartitionNodeBuilder create() {
        PartitionNodeBuilder builder = new PartitionNodeBuilder();
        return builder;
    }

    public Node build(Partition partition, Graph graph) {
        PartitionLabelBuilder labelBuilder = this.labelBuilder.apply(partition);
        labelBuilder.parent(this);
        Node node = graph.addNode(SchemaGraphUtils.getName(partition));
        node.setFontname(this.getDrawOption().getFont());
        node.setFontsize(this.getDrawOption().getNodeFontsize());
        Table table = (Table)partition.getAncestor(Table.class);
        if (table != null) {
            node.setUrl("tables/" + SchemaGraphUtils.getName(table) + ".html");
        }
        node.setHtmlLabel(tableElement -> labelBuilder.build(partition, (TableElement)tableElement));
        if (this.setAttribute != null) {
            this.setAttribute.accept(partition, node);
        }
        node.set_context(partition);
        return node;
    }

    protected PartitionNodeBuilder instance() {
        return this;
    }

    public PartitionNodeBuilder labelBuilder(Function<Partition, PartitionLabelBuilder> labelBuilder) {
        this.labelBuilder = labelBuilder;
        return this;
    }

    public PartitionNodeBuilder labelBuilder(PartitionLabelBuilder lableBuilder) {
        this.labelBuilder = partition -> lableBuilder;
        return this;
    }

    public Function<Partition, PartitionLabelBuilder> labelBuilder() {
        return this.labelBuilder;
    }

    public BiConsumer<Partition, Node> setAttribute() {
        return this.setAttribute;
    }

    public PartitionNodeBuilder setAttribute(BiConsumer<Partition, Node> setAttribute) {
        this.setAttribute = setAttribute;
        return this;
    }
}

