/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractEdge;
import com.sqlapp.graphviz.Graph;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.NodePort;
import com.sqlapp.graphviz.Port;
import com.sqlapp.graphviz.Props;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class Edge
extends AbstractEdge<Edge> {
    @Props
    private Double weight = null;
    private NodePort[] nodes;

    public Edge(Object ... args) {
        this.nodes = Edge.toNodePorts(args);
    }

    public Edge(NodePort ... nodes) {
        this.nodes = nodes;
    }

    public Edge(NodePort from, NodePort to) {
        this.nodes = new NodePort[]{from, to};
    }

    public Edge(Node from, Node to) {
        this.nodes = new NodePort[]{new NodePort(from), new NodePort(to)};
    }

    public Edge(Node from, Port portFrom, Node to, Port portTo) {
        this.nodes = new NodePort[]{new NodePort(from, portFrom), new NodePort(to, portTo)};
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Graph getRoot() {
        Graph graph = this.getGraph();
        if (graph.getParent() == null) {
            return null;
        }
        if (this.getParent().getParent() == null) {
            return null;
        }
        return graph.getRoot();
    }

    public Graph getGraph() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getParent();
    }

    @Override
    protected String getNodeName() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        Graph graph = null;
        if (this.getParent() != null && this.getParent().getParent() != null) {
            graph = this.getParent().getParent().getRoot();
        }
        String arrow = graph != null && graph.isDirected() ? " -> " : " -- ";
        for (NodePort node : this.nodes) {
            if (!first) {
                builder.append(arrow);
            } else {
                first = false;
            }
            builder.append(node.toString());
        }
        return builder.toString();
    }

    protected void setNode(NodePort from, NodePort to) {
        this.setNode(new NodePort[]{from, to});
    }

    private void setNode(NodePort[] nodes) {
        if (nodes != null) {
            for (NodePort node : nodes) {
                node.setParent(this);
            }
        }
        this.nodes = nodes;
    }

    protected void setNode(Node from, Node to) {
        this.setNode(new NodePort[]{new NodePort(from), new NodePort(to)});
    }

    protected void setNode(Node from, Port portFrom, Node to, Port portTo) {
        this.setNode(new NodePort[]{new NodePort(from, portFrom), new NodePort(to, portTo)});
    }

    protected void setNode(Object ... args) {
        this.setNode(Edge.toNodePorts(args));
    }

    private static NodePort[] toNodePorts(Object ... args) {
        if (args == null || args.length == 0) {
            return new NodePort[0];
        }
        ArrayList<NodePort> list = new ArrayList<NodePort>();
        int i = 0;
        while (i < args.length) {
            Object obj;
            if ((obj = args[i++]) instanceof Node) {
                Node node = (Node)obj;
                Port port = null;
                if (i < args.length && args[i] instanceof Port) {
                    port = (Port)args[i];
                }
                list.add(new NodePort(node, port));
                continue;
            }
            throw new IllegalArgumentException("args[" + (i - 1) + "] is not Node. args[" + (i - 1) + "]=" + obj);
        }
        return list.toArray(new NodePort[0]);
    }

    @Override
    protected Map<String, Object> getProperties() {
        Map<String, Object> props = super.getProperties();
        this.put(props, "weight", this.weight);
        return props;
    }

    public Double getWeight() {
        return this.weight;
    }

    public NodePort[] getNodes() {
        return this.nodes;
    }

    public void setNodes(NodePort[] nodes) {
        this.nodes = nodes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$weight = this.getWeight();
        Double other$weight = other.getWeight();
        if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodes(), other.getNodes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Edge;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodes());
        return result;
    }
}

