/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractElementCollection;
import com.sqlapp.graphviz.DuplicateGraphException;
import com.sqlapp.graphviz.Graph;
import java.util.LinkedHashMap;
import java.util.Map;

public class GraphCollection
extends AbstractElementCollection<Graph> {
    private static final long serialVersionUID = 6685111479972906357L;
    private final Graph parent;
    private Map<String, Graph> map = new LinkedHashMap<String, Graph>();

    protected GraphCollection(Graph parent) {
        this.parent = parent;
    }

    @Override
    protected void renew() {
        this.map.clear();
        this.getList().forEach(c -> {
            if (this.map.containsKey(c.getName())) {
                throw new DuplicateGraphException((Graph)c);
            }
            this.map.put(c.getName(), (Graph)c);
            c.setParent(this);
        });
    }

    public <T extends Graph> T get(String name) {
        return (T)this.map.get(name);
    }

    public Graph getParent() {
        return this.parent;
    }
}

