/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.labeltable;

import com.sqlapp.graphviz.AbstractGraphVizElement;
import com.sqlapp.graphviz.Node;
import com.sqlapp.util.StaxWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractHtmlElement
extends AbstractGraphVizElement {
    private AbstractHtmlElement parent = null;
    private Node node;

    protected abstract void writeXml(StaxWriter var1) throws XMLStreamException;

    protected AbstractHtmlElement() {
    }

    protected AbstractHtmlElement(Node node) {
        this.node = node;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            StaxWriter staxWriter = new StaxWriter((Writer)writer);
            staxWriter.setHtmlMode();
            this.writeXml(staxWriter);
            return writer.getBuffer().toString();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(int indentSize) {
        StringWriter writer = new StringWriter();
        try {
            StaxWriter staxWriter = new StaxWriter((Writer)writer);
            staxWriter.setHtmlMode();
            staxWriter.setIndentLevel(indentSize);
            this.writeXml(staxWriter);
            return writer.getBuffer().toString();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected Node getNode() {
        return this.node;
    }

    protected void setNode(Node node) {
        this.node = node;
    }

    protected void setParent(AbstractHtmlElement parent) {
        this.parent = parent;
    }

    protected <T extends AbstractHtmlElement> T getParent() {
        return (T)this.parent;
    }

    protected <T extends AbstractHtmlElement> T getRoot() {
        return this.getParent(this);
    }

    protected <T extends AbstractHtmlElement> T getParent(AbstractHtmlElement element) {
        if (element.parent == null) {
            return (T)element;
        }
        return this.getParent(element.parent);
    }
}

