/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.schemas;

import com.sqlapp.data.schemas.Partition;
import com.sqlapp.graphviz.labeltable.Align;
import com.sqlapp.graphviz.labeltable.TdElement;
import com.sqlapp.graphviz.labeltable.TrElement;
import com.sqlapp.graphviz.schemas.AbstractSchemaGraphBuilder;
import java.util.function.Function;

public class PartitionDetailCellBuilder
extends AbstractSchemaGraphBuilder {
    private String defaultColor = null;
    private String defaultBgcolor = "#A9D0F5";
    private Function<Partition, String> name = c -> c.getName();
    private Function<Partition, String> color = c -> this.defaultColor();
    private Function<Partition, String> bgcolor = c -> this.defaultBgcolor();
    private boolean createEmptyCell = true;
    private Function<Partition, String> highValue = c -> c.getHighValue();
    private Function<Partition, String> lowValue = c -> c.getLowValue();
    private int colspan = 1;

    private PartitionDetailCellBuilder() {
    }

    public static PartitionDetailCellBuilder create() {
        PartitionDetailCellBuilder builder = new PartitionDetailCellBuilder();
        return builder;
    }

    public static PartitionDetailCellBuilder createSimple() {
        PartitionDetailCellBuilder builder = new PartitionDetailCellBuilder();
        builder.createEmptyCell(false);
        builder.highValue(c -> c.getLowValue());
        builder.lowValue(c -> c.getHighValue());
        return builder;
    }

    public void build(Partition partition, TrElement tr) {
        this.createHead(partition, tr);
        this.createLowValue(partition, tr);
        this.createHighValue(partition, tr);
        this.createTail(partition, tr);
    }

    private PartitionDetailCellBuilder createHead(Partition partition, TrElement tr) {
        tr.addCell(cell -> {
            this.setCommonAttribute(partition, (TdElement)cell);
            cell.setValue("");
        });
        return this.instance();
    }

    private PartitionDetailCellBuilder createTail(Partition partition, TrElement tr) {
        tr.addCell(cell -> {
            this.setCommonAttribute(partition, (TdElement)cell);
            cell.setValue("");
        });
        return this.instance();
    }

    private void addEmptyCell(Partition partition, TrElement tr) {
        if (this.createEmptyCell) {
            tr.addCell(cell -> {
                this.setCommonAttribute(partition, (TdElement)cell);
                cell.setValue("");
            });
        }
    }

    private PartitionDetailCellBuilder createLowValue(Partition partition, TrElement tr) {
        String value = this.lowValue.apply(partition);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(partition, (TdElement)cell);
                cell.setValue(value);
            });
        } else {
            this.addEmptyCell(partition, tr);
        }
        return this.instance();
    }

    private PartitionDetailCellBuilder createHighValue(Partition partition, TrElement tr) {
        String value = this.highValue.apply(partition);
        if (value != null) {
            tr.addCell(cell -> {
                this.setCommonAttribute(partition, (TdElement)cell);
                cell.setValue(value);
            });
        } else {
            this.addEmptyCell(partition, tr);
        }
        return this.instance();
    }

    private PartitionDetailCellBuilder setCommonAttribute(Partition partition, TdElement cell) {
        cell.setAlign(Align.LEFT);
        cell.setColor(this.getPartitionColor(partition));
        cell.setBgcolor(this.getBgcolor(partition));
        return this.instance();
    }

    private PartitionDetailCellBuilder instance() {
        return this;
    }

    private String getPartitionColor(Partition partition) {
        String value = this.color.apply(partition);
        if (value == null) {
            return this.defaultColor();
        }
        return value;
    }

    private String getBgcolor(Partition partition) {
        String value = this.bgcolor.apply(partition);
        if (value == null) {
            return this.defaultBgcolor();
        }
        return value;
    }

    public String defaultColor() {
        return this.defaultColor;
    }

    public String defaultBgcolor() {
        return this.defaultBgcolor;
    }

    public Function<Partition, String> name() {
        return this.name;
    }

    public Function<Partition, String> color() {
        return this.color;
    }

    public Function<Partition, String> bgcolor() {
        return this.bgcolor;
    }

    public boolean createEmptyCell() {
        return this.createEmptyCell;
    }

    public Function<Partition, String> highValue() {
        return this.highValue;
    }

    public Function<Partition, String> lowValue() {
        return this.lowValue;
    }

    public int colspan() {
        return this.colspan;
    }

    public PartitionDetailCellBuilder defaultColor(String defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    public PartitionDetailCellBuilder defaultBgcolor(String defaultBgcolor) {
        this.defaultBgcolor = defaultBgcolor;
        return this;
    }

    public PartitionDetailCellBuilder name(Function<Partition, String> name) {
        this.name = name;
        return this;
    }

    public PartitionDetailCellBuilder color(Function<Partition, String> color) {
        this.color = color;
        return this;
    }

    public PartitionDetailCellBuilder bgcolor(Function<Partition, String> bgcolor) {
        this.bgcolor = bgcolor;
        return this;
    }

    public PartitionDetailCellBuilder createEmptyCell(boolean createEmptyCell) {
        this.createEmptyCell = createEmptyCell;
        return this;
    }

    public PartitionDetailCellBuilder highValue(Function<Partition, String> highValue) {
        this.highValue = highValue;
        return this;
    }

    public PartitionDetailCellBuilder lowValue(Function<Partition, String> lowValue) {
        this.lowValue = lowValue;
        return this;
    }

    public PartitionDetailCellBuilder colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }
}

