/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz;

import com.sqlapp.graphviz.AbstractCommonElement;
import com.sqlapp.graphviz.AbstractGraphVizElement;
import com.sqlapp.graphviz.Edge;
import com.sqlapp.graphviz.EdgeCollection;
import com.sqlapp.graphviz.EdgeSetting;
import com.sqlapp.graphviz.GraphCollection;
import com.sqlapp.graphviz.GraphSetting;
import com.sqlapp.graphviz.GraphStringBuilder;
import com.sqlapp.graphviz.GraphVizElementUtils;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.NodeCollection;
import com.sqlapp.graphviz.NodePort;
import com.sqlapp.graphviz.NodeSetting;
import com.sqlapp.graphviz.Port;
import com.sqlapp.graphviz.PortNotFoundException;
import com.sqlapp.graphviz.Rank;
import com.sqlapp.graphviz.RankCollection;
import com.sqlapp.graphviz.RankType;
import com.sqlapp.graphviz.ToGraphStringBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class Graph
extends AbstractCommonElement<Graph> {
    private boolean directed;
    private boolean cluster;
    private GraphCollection parent;
    private String name = null;
    private GraphCollection graphs = new GraphCollection(this);
    private NodeCollection nodes = new NodeCollection(this);
    private EdgeCollection edges = new EdgeCollection(this);
    private RankCollection ranks = new RankCollection(this);
    private List<AbstractGraphVizElement> elements = new ArrayList<AbstractGraphVizElement>();

    public Graph(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        if (this.isCluster()) {
            return "cluster_" + this.name;
        }
        return this.name;
    }

    @Override
    protected Graph instance() {
        return this;
    }

    public Node addNode(String name) {
        Object node = this.nodes.get(name);
        if (node != null) {
            return node;
        }
        node = new Node(name);
        return this.addNode(node);
    }

    public Graph addNode(Consumer<Node> c, String ... names) {
        ArrayList list = new ArrayList();
        for (String name : names) {
            Object node = this.nodes.get(name);
            if (node != null) continue;
            node = new Node(name);
            list.add(node);
        }
        this.nodes.addAll(list);
        this.elements.addAll(list);
        if (c != null) {
            list.forEach(obj -> c.accept((Node)obj));
        }
        return this.instance();
    }

    public Graph addRank(RankType rankType, Node ... nodes) {
        if (CommonUtils.isEmpty((Object)nodes)) {
            return this.instance();
        }
        Rank rank = new Rank(rankType, nodes);
        this.ranks.add(rank);
        this.elements.add(rank);
        return this.instance();
    }

    public Graph addRank(RankType rankType, Collection<Node> nodes) {
        if (CommonUtils.isEmpty(nodes)) {
            return this.instance();
        }
        Rank rank = new Rank(rankType, nodes.toArray(new Node[0]));
        this.ranks.add(rank);
        this.elements.add(rank);
        return this.instance();
    }

    public Graph addRank(Node ... nodes) {
        return this.addRank(RankType.same, nodes);
    }

    public Graph addRank(RankType rankType, String ... nodes) {
        return this.addRank(rankType, this.getNodesInternal(nodes).toArray(new Node[0]));
    }

    public Graph addRank(String ... nodes) {
        return this.addRank(RankType.same, nodes);
    }

    private List<Node> getNodesInternal(String ... nodes) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (CommonUtils.isEmpty((Object)nodes)) {
            return list;
        }
        for (String name : nodes) {
            Object node = this.nodes.get(name);
            if (node == null) {
                throw new IllegalArgumentException("Node[" + name + "] not found.");
            }
            list.add((Node)node);
        }
        return list;
    }

    public <T extends Node> T addNode(T node) {
        this.nodes.add(node);
        this.elements.add(node);
        return node;
    }

    public Graph addNode(Consumer<Node> c, Node ... args) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node : args) {
            Object nd = this.nodes.get(node.getName());
            if (nd != null) {
                node = nd;
            }
            list.add(node);
        }
        this.nodes.addAll(list);
        this.elements.addAll(list);
        if (c != null) {
            list.forEach(obj -> c.accept((Node)obj));
        }
        return this.instance();
    }

    public Graph addGraph(Consumer<Graph> c, String ... args) {
        ArrayList<Graph> list = new ArrayList<Graph>();
        for (String arg : args) {
            Graph graph = new Graph(arg);
            list.add(graph);
        }
        this.graphs.addAll(list);
        this.elements.addAll(list);
        if (c != null) {
            list.forEach(obj -> c.accept((Graph)obj));
        }
        return this.instance();
    }

    public Graph addGraph(Graph graph) {
        this.graphs.add(graph);
        this.elements.add(graph);
        return this.instance();
    }

    public Edge addEdge(Node from, Node to) {
        Edge obj = new Edge(from, to);
        this.edges.add(obj);
        this.elements.add(obj);
        return obj;
    }

    public Node getNode(String name) {
        Object node = this.nodes.get(name);
        if (node != null) {
            return node;
        }
        for (Graph graph : this.graphs) {
            node = graph.getNode(name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public Graph addGraphSetting(Consumer<GraphSetting> c) {
        GraphSetting obj = new GraphSetting(this);
        this.elements.add(obj);
        c.accept(obj);
        return this.instance();
    }

    public GraphSetting addGraphSetting() {
        GraphSetting obj = new GraphSetting(this);
        this.elements.add(obj);
        return obj;
    }

    public Graph addNodeSetting(Consumer<NodeSetting> c) {
        NodeSetting obj = new NodeSetting(this);
        this.elements.add(obj);
        c.accept(obj);
        return this.instance();
    }

    public NodeSetting addNodeSetting() {
        NodeSetting obj = new NodeSetting(this);
        this.elements.add(obj);
        return obj;
    }

    public Graph addEdgeSetting(Consumer<EdgeSetting> c) {
        EdgeSetting obj = new EdgeSetting(this);
        this.elements.add(obj);
        c.accept(obj);
        return this.instance();
    }

    public EdgeSetting addEdgeSetting() {
        EdgeSetting obj = new EdgeSetting(this);
        this.elements.add(obj);
        return obj;
    }

    public Edge addEdge(NodePort ... nodes) {
        Edge obj = new Edge(nodes);
        this.edges.add(obj);
        this.elements.add(obj);
        return obj;
    }

    public Graph addEdge(Consumer<Edge> c, Node ... nodes) {
        Edge obj = new Edge(nodes);
        this.edges.add(obj);
        this.elements.add(obj);
        if (c != null) {
            c.accept(obj);
        }
        return this.instance();
    }

    public Graph addEdge(Consumer<Edge> c, NodePort ... nodes) {
        Edge obj = new Edge(nodes);
        this.edges.add(obj);
        this.elements.add(obj);
        if (c != null) {
            c.accept(obj);
        }
        return this.instance();
    }

    public Graph addEdge(Consumer<Edge> c, String ... nodePorts) {
        for (String nodePort : nodePorts) {
            String[] splits = nodePort.split("\\s*->\\s*");
            for (int i = 0; i < splits.length - 1; ++i) {
                this.addEdgeInternal(c, splits[i], splits[i + 1]);
            }
        }
        return this.instance();
    }

    public Graph addEdge(String ... nodePorts) {
        if (nodePorts == null || nodePorts.length == 0) {
            throw new IllegalArgumentException("nodePorts=" + Arrays.toString(nodePorts));
        }
        return this.addEdge((Consumer<Edge>)null, nodePorts);
    }

    private void addEdgeInternal(Consumer<Edge> c, String ... nodePorts) {
        ArrayList<NodePort> list = new ArrayList<NodePort>();
        for (String nodePort : nodePorts) {
            Node node = null;
            Port port = null;
            if (nodePort.contains(":")) {
                String[] splits = nodePort.split("\\s*:\\s*");
                node = this.getNode(splits[0].trim());
                port = node.getPort(splits[1].trim());
                if (port == null) {
                    throw new PortNotFoundException(splits[0].trim(), splits[1].trim());
                }
            } else {
                node = this.getNode(nodePort.trim());
                port = null;
            }
            list.add(new NodePort(node, port));
        }
        this.addEdge(c, list.toArray(new NodePort[0]));
    }

    public Edge addEdge(Node from, Port portFrom, Node to, Port portTo) {
        Edge obj = new Edge(from, portFrom, to, portTo);
        this.edges.add(obj);
        this.elements.add(obj);
        return obj;
    }

    @Override
    protected GraphStringBuilder createGraphStringBuilder() {
        GraphStringBuilder builder = new GraphStringBuilder(this.graphName());
        builder.setIndentLevel(this.level());
        builder.setOpen("{").setClose("}");
        return builder;
    }

    private String graphName() {
        if (this.level() == 0) {
            if (this.isDirected()) {
                return "digraph " + GraphVizElementUtils.escapeName(this.getName());
            }
            return "graph " + GraphVizElementUtils.escapeName(this.getName());
        }
        return "subgraph " + GraphVizElementUtils.escapeName(this.getName());
    }

    public boolean isSubgraph() {
        return this.getParent() != null;
    }

    public boolean isCluster() {
        return this.isSubgraph() && this.cluster;
    }

    private int level() {
        int i = 0;
        if (this.getParent() == null) {
            return i;
        }
        return this.level(this.getParent().getParent(), i + 1);
    }

    private int level(Graph graph, int i) {
        if (graph.getParent() == null) {
            return i;
        }
        return this.level(this.getParent().getParent(), i + 1);
    }

    @Override
    public String toString() {
        GraphStringBuilder builder = this.toGraphStringBuilder();
        return builder.toString();
    }

    @Override
    public GraphStringBuilder toGraphStringBuilder() {
        GraphStringBuilder builder = this.createGraphStringBuilder();
        builder.put("label", this.getLabel());
        this.getProperties().forEach((k, v) -> builder.put((String)k, v));
        for (AbstractGraphVizElement element : this.elements) {
            if (element instanceof ToGraphStringBuilder) {
                GraphStringBuilder child = ((ToGraphStringBuilder)((Object)element)).toGraphStringBuilder();
                if (element instanceof Edge) {
                    child.setIndentLevel(builder.getIndentLevel() + 1);
                    builder.put(child);
                    continue;
                }
                if (child.isEmpty()) continue;
                child.setIndentLevel(builder.getIndentLevel() + 1);
                builder.put(child);
                continue;
            }
            throw new RuntimeException("Invalid elemnt. element=[" + element + "]");
        }
        return builder;
    }

    protected Graph getRoot() {
        return this.getParent(this);
    }

    protected Graph getParent(Graph graph) {
        if (graph == null) {
            return this;
        }
        if (graph.parent == null) {
            return graph;
        }
        return this.getParent(graph.parent.getParent());
    }

    public boolean isDirected() {
        return this.directed;
    }

    public List<AbstractGraphVizElement> getElements() {
        return this.elements;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setElements(List<AbstractGraphVizElement> elements) {
        this.elements = elements;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph other = (Graph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDirected() != other.isDirected()) {
            return false;
        }
        if (this.isCluster() != other.isCluster()) {
            return false;
        }
        GraphCollection this$parent = this.getParent();
        GraphCollection other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        GraphCollection this$graphs = this.getGraphs();
        GraphCollection other$graphs = other.getGraphs();
        if (this$graphs == null ? other$graphs != null : !((Object)this$graphs).equals(other$graphs)) {
            return false;
        }
        NodeCollection this$nodes = this.getNodes();
        NodeCollection other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        EdgeCollection this$edges = this.getEdges();
        EdgeCollection other$edges = other.getEdges();
        if (this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges)) {
            return false;
        }
        RankCollection this$ranks = this.getRanks();
        RankCollection other$ranks = other.getRanks();
        if (this$ranks == null ? other$ranks != null : !((Object)this$ranks).equals(other$ranks)) {
            return false;
        }
        List<AbstractGraphVizElement> this$elements = this.getElements();
        List<AbstractGraphVizElement> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Graph;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDirected() ? 79 : 97);
        result = result * 59 + (this.isCluster() ? 79 : 97);
        GraphCollection $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        GraphCollection $graphs = this.getGraphs();
        result = result * 59 + ($graphs == null ? 43 : ((Object)$graphs).hashCode());
        NodeCollection $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        EdgeCollection $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        RankCollection $ranks = this.getRanks();
        result = result * 59 + ($ranks == null ? 43 : ((Object)$ranks).hashCode());
        List<AbstractGraphVizElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    public GraphCollection getParent() {
        return this.parent;
    }

    protected void setParent(GraphCollection parent) {
        this.parent = parent;
    }

    private GraphCollection getGraphs() {
        return this.graphs;
    }

    private void setGraphs(GraphCollection graphs) {
        this.graphs = graphs;
    }

    private NodeCollection getNodes() {
        return this.nodes;
    }

    private void setNodes(NodeCollection nodes) {
        this.nodes = nodes;
    }

    private EdgeCollection getEdges() {
        return this.edges;
    }

    private void setEdges(EdgeCollection edges) {
        this.edges = edges;
    }

    private RankCollection getRanks() {
        return this.ranks;
    }

    private void setRanks(RankCollection ranks) {
        this.ranks = ranks;
    }
}

