/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.graphviz.labeltable;

import com.sqlapp.graphviz.GraphVizElementUtils;
import com.sqlapp.graphviz.Node;
import com.sqlapp.graphviz.Port;
import com.sqlapp.graphviz.PortCollection;
import com.sqlapp.graphviz.labeltable.AbstractHtmlElement;
import com.sqlapp.graphviz.labeltable.Align;
import com.sqlapp.graphviz.labeltable.TrElement;
import com.sqlapp.graphviz.labeltable.VAlign;
import com.sqlapp.util.StaxWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;

public class TableElement
extends AbstractHtmlElement {
    private Align align = null;
    private Align balign = null;
    private String bgcolor;
    private Integer border = null;
    private Integer cellpadding = null;
    private Integer cellspacing;
    private String color;
    private boolean fixedsize = false;
    private String gradientAngle;
    private String height;
    private String href;
    private String id;
    private Port port;
    private String sides;
    private String style;
    private String target;
    private String title;
    private String tooltip;
    private String width;
    private VAlign valign;
    private List<TrElement> rows = new ArrayList<TrElement>();

    public TableElement() {
    }

    public TableElement(Node node) {
        super(node);
    }

    protected PortCollection getPorts() {
        return GraphVizElementUtils.getPorts(((AbstractHtmlElement)this.getRoot()).getNode());
    }

    protected String getElementName() {
        return "table";
    }

    public TableElement setPort(String value) {
        Port port = new Port(value);
        GraphVizElementUtils.setParent(port, ((AbstractHtmlElement)this.getRoot()).getNode());
        this.port = port;
        return this.instance();
    }

    public TableElement addRow(Consumer<TrElement> c) {
        TrElement tr = new TrElement();
        tr.setParent(this);
        this.rows.add(tr);
        c.accept(tr);
        return this.instance();
    }

    public TableElement addRow(int index, Consumer<TrElement> c) {
        TrElement tr = new TrElement();
        tr.setParent(this);
        this.rows.add(index, tr);
        c.accept(tr);
        return this.instance();
    }

    public TableElement addRows(BiConsumer<TrElement, Integer> c, int rowSize) {
        for (int i = 0; i < rowSize; ++i) {
            TrElement tr = new TrElement();
            tr.setParent(this);
            this.rows.add(tr);
            c.accept(tr, i);
        }
        return this.instance();
    }

    protected TableElement instance() {
        return this;
    }

    @Override
    protected void writeXml(StaxWriter staxWriter) throws XMLStreamException {
        staxWriter.writeStartElement(this.getElementName());
        staxWriter.writeAttribute("align", (Object)this.align);
        staxWriter.writeAttribute("balign", (Object)this.balign);
        staxWriter.writeAttribute("bgcolor", this.bgcolor);
        staxWriter.writeAttribute("border", (Object)this.border);
        staxWriter.writeAttribute("cellpadding", (Object)this.cellpadding);
        staxWriter.writeAttribute("cellspacing", (Object)this.cellspacing);
        staxWriter.writeAttribute("color", this.color);
        if (this.fixedsize) {
            staxWriter.writeAttribute("fixedsize", (Object)this.fixedsize);
        }
        staxWriter.writeAttribute("gradientangle", this.gradientAngle);
        staxWriter.writeAttribute("height", this.height);
        staxWriter.writeAttribute("href", this.href);
        staxWriter.writeAttribute("id", this.id);
        if (this.port != null) {
            staxWriter.writeAttribute("port", this.port.getValue());
        }
        staxWriter.writeAttribute("sides", this.sides);
        staxWriter.writeAttribute("style", this.style);
        staxWriter.writeAttribute("target", this.target);
        staxWriter.writeAttribute("title", this.title);
        staxWriter.writeAttribute("tooltip", this.tooltip);
        staxWriter.writeAttribute("width", this.width);
        staxWriter.writeAttribute("valign", (Object)this.valign);
        if (!this.rows.isEmpty()) {
            staxWriter.addIndentLevel(1);
            for (TrElement element : this.rows) {
                staxWriter.newLine();
                staxWriter.indent();
                element.writeXml(staxWriter);
            }
            staxWriter.addIndentLevel(-1);
            staxWriter.newLine();
            staxWriter.indent();
        }
        staxWriter.writeEndElement();
    }

    public Align getAlign() {
        return this.align;
    }

    public Align getBalign() {
        return this.balign;
    }

    public String getBgcolor() {
        return this.bgcolor;
    }

    public Integer getBorder() {
        return this.border;
    }

    public Integer getCellpadding() {
        return this.cellpadding;
    }

    public Integer getCellspacing() {
        return this.cellspacing;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isFixedsize() {
        return this.fixedsize;
    }

    public String getGradientAngle() {
        return this.gradientAngle;
    }

    public String getHeight() {
        return this.height;
    }

    public String getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public Port getPort() {
        return this.port;
    }

    public String getSides() {
        return this.sides;
    }

    public String getStyle() {
        return this.style;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getWidth() {
        return this.width;
    }

    public VAlign getValign() {
        return this.valign;
    }

    public List<TrElement> getRows() {
        return this.rows;
    }

    public TableElement setAlign(Align align) {
        this.align = align;
        return this;
    }

    public TableElement setBalign(Align balign) {
        this.balign = balign;
        return this;
    }

    public TableElement setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
        return this;
    }

    public TableElement setBorder(Integer border) {
        this.border = border;
        return this;
    }

    public TableElement setCellpadding(Integer cellpadding) {
        this.cellpadding = cellpadding;
        return this;
    }

    public TableElement setCellspacing(Integer cellspacing) {
        this.cellspacing = cellspacing;
        return this;
    }

    public TableElement setColor(String color) {
        this.color = color;
        return this;
    }

    public TableElement setFixedsize(boolean fixedsize) {
        this.fixedsize = fixedsize;
        return this;
    }

    public TableElement setGradientAngle(String gradientAngle) {
        this.gradientAngle = gradientAngle;
        return this;
    }

    public TableElement setHeight(String height) {
        this.height = height;
        return this;
    }

    public TableElement setHref(String href) {
        this.href = href;
        return this;
    }

    public TableElement setId(String id) {
        this.id = id;
        return this;
    }

    public TableElement setSides(String sides) {
        this.sides = sides;
        return this;
    }

    public TableElement setStyle(String style) {
        this.style = style;
        return this;
    }

    public TableElement setTarget(String target) {
        this.target = target;
        return this;
    }

    public TableElement setTitle(String title) {
        this.title = title;
        return this;
    }

    public TableElement setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public TableElement setWidth(String width) {
        this.width = width;
        return this;
    }

    public TableElement setValign(VAlign valign) {
        this.valign = valign;
        return this;
    }

    public TableElement setRows(List<TrElement> rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableElement)) {
            return false;
        }
        TableElement other = (TableElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isFixedsize() != other.isFixedsize()) {
            return false;
        }
        Integer this$border = this.getBorder();
        Integer other$border = other.getBorder();
        if (this$border == null ? other$border != null : !((Object)this$border).equals(other$border)) {
            return false;
        }
        Integer this$cellpadding = this.getCellpadding();
        Integer other$cellpadding = other.getCellpadding();
        if (this$cellpadding == null ? other$cellpadding != null : !((Object)this$cellpadding).equals(other$cellpadding)) {
            return false;
        }
        Integer this$cellspacing = this.getCellspacing();
        Integer other$cellspacing = other.getCellspacing();
        if (this$cellspacing == null ? other$cellspacing != null : !((Object)this$cellspacing).equals(other$cellspacing)) {
            return false;
        }
        Align this$align = this.getAlign();
        Align other$align = other.getAlign();
        if (this$align == null ? other$align != null : !((Object)((Object)this$align)).equals((Object)other$align)) {
            return false;
        }
        Align this$balign = this.getBalign();
        Align other$balign = other.getBalign();
        if (this$balign == null ? other$balign != null : !((Object)((Object)this$balign)).equals((Object)other$balign)) {
            return false;
        }
        String this$bgcolor = this.getBgcolor();
        String other$bgcolor = other.getBgcolor();
        if (this$bgcolor == null ? other$bgcolor != null : !this$bgcolor.equals(other$bgcolor)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$gradientAngle = this.getGradientAngle();
        String other$gradientAngle = other.getGradientAngle();
        if (this$gradientAngle == null ? other$gradientAngle != null : !this$gradientAngle.equals(other$gradientAngle)) {
            return false;
        }
        String this$height = this.getHeight();
        String other$height = other.getHeight();
        if (this$height == null ? other$height != null : !this$height.equals(other$height)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Port this$port = this.getPort();
        Port other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$sides = this.getSides();
        String other$sides = other.getSides();
        if (this$sides == null ? other$sides != null : !this$sides.equals(other$sides)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$tooltip = this.getTooltip();
        String other$tooltip = other.getTooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        String this$width = this.getWidth();
        String other$width = other.getWidth();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) {
            return false;
        }
        VAlign this$valign = this.getValign();
        VAlign other$valign = other.getValign();
        if (this$valign == null ? other$valign != null : !((Object)((Object)this$valign)).equals((Object)other$valign)) {
            return false;
        }
        List<TrElement> this$rows = this.getRows();
        List<TrElement> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isFixedsize() ? 79 : 97);
        Integer $border = this.getBorder();
        result = result * 59 + ($border == null ? 43 : ((Object)$border).hashCode());
        Integer $cellpadding = this.getCellpadding();
        result = result * 59 + ($cellpadding == null ? 43 : ((Object)$cellpadding).hashCode());
        Integer $cellspacing = this.getCellspacing();
        result = result * 59 + ($cellspacing == null ? 43 : ((Object)$cellspacing).hashCode());
        Align $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : ((Object)((Object)$align)).hashCode());
        Align $balign = this.getBalign();
        result = result * 59 + ($balign == null ? 43 : ((Object)((Object)$balign)).hashCode());
        String $bgcolor = this.getBgcolor();
        result = result * 59 + ($bgcolor == null ? 43 : $bgcolor.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $gradientAngle = this.getGradientAngle();
        result = result * 59 + ($gradientAngle == null ? 43 : $gradientAngle.hashCode());
        String $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : $height.hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Port $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $sides = this.getSides();
        result = result * 59 + ($sides == null ? 43 : $sides.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        String $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : $width.hashCode());
        VAlign $valign = this.getValign();
        result = result * 59 + ($valign == null ? 43 : ((Object)((Object)$valign)).hashCode());
        List<TrElement> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }
}

