/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.stackify.api.common.log.LogBackgroundServiceScheduler;
import com.stackify.api.common.log.LogCollector;
import com.stackify.api.common.log.LogSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBackgroundService
extends AbstractScheduledService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogBackgroundService.class);
    private final LogBackgroundServiceScheduler scheduler = new LogBackgroundServiceScheduler();
    private final LogCollector collector;
    private final LogSender sender;

    public LogBackgroundService(LogCollector collector, LogSender sender) {
        Preconditions.checkNotNull((Object)collector);
        Preconditions.checkNotNull((Object)sender);
        this.collector = collector;
        this.sender = sender;
    }

    protected String serviceName() {
        return "Stackify_LogBackgroundService";
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return this.scheduler;
    }

    protected void shutDown() throws Exception {
        try {
            this.collector.flush(this.sender);
        }
        catch (Throwable t) {
            LOGGER.info("Exception flushing log collector during shut down", t);
        }
        super.shutDown();
    }

    protected void runOneIteration() {
        try {
            int numSent = this.collector.flush(this.sender);
            this.scheduler.update(numSent);
        }
        catch (Throwable t) {
            LOGGER.info("Exception running Stackify_LogBackgroundService", t);
            this.scheduler.update(t);
        }
    }
}

