/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log.direct;

import com.google.common.base.Objects;

public class LogEvent {
    private final String level;
    private final String message;
    private final Throwable exception;
    private final long timestamp;

    public String getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private LogEvent(Builder builder) {
        this.level = builder.level;
        this.message = builder.message;
        this.exception = builder.exception;
        this.timestamp = System.currentTimeMillis();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("level", (Object)this.level).add("message", (Object)this.message).add("exception", (Object)this.exception).add("timestamp", this.timestamp).toString();
    }

    public static class Builder {
        private String level;
        private String message;
        private Throwable exception;

        public Builder level(String level) {
            this.level = level;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public LogEvent build() {
            return new LogEvent(this);
        }
    }
}

