/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log.direct;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.direct.LogEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class LogEventAdapter
implements EventAdapter<LogEvent> {
    private final EnvironmentDetail envDetail;

    public LogEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull((Object)envDetail);
        this.envDetail = envDetail;
    }

    @Override
    public Optional<Throwable> getThrowable(LogEvent event) {
        return Optional.fromNullable((Object)event.getException());
    }

    @Override
    public StackifyError getStackifyError(LogEvent event, Throwable exception) {
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimestamp()));
        builder.error(Throwables.toErrorItem(event.getMessage(), exception));
        builder.serverVariables((Map)Maps.fromProperties((Properties)System.getProperties()));
        return builder.build();
    }

    @Override
    public LogMsg getLogMsg(LogEvent event, Optional<StackifyError> error) {
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(event.getMessage());
        builder.ex((StackifyError)error.orNull());
        builder.epochMs(Long.valueOf(event.getTimestamp()));
        if (event.getLevel() != null) {
            builder.level(event.getLevel().toLowerCase());
        }
        return builder.build();
    }
}

