/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log.direct;

import com.stackify.api.common.log.LogAppender;
import com.stackify.api.common.log.direct.LogEvent;
import com.stackify.api.common.log.direct.LogManager;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(Logger.class);

    public static void queueMessage(String level, String message) {
        try {
            LogAppender<LogEvent> appender = LogManager.getAppender();
            if (appender != null) {
                appender.append(LogEvent.newBuilder().level(level).message(message).build());
            }
        }
        catch (Throwable t) {
            LOGGER.info("Unable to queue message to Stackify Log API service: {} {}", new Object[]{level, message, t});
        }
    }

    public static void queueException(Throwable e) {
        if (e != null) {
            try {
                LogAppender<LogEvent> appender = LogManager.getAppender();
                if (appender != null) {
                    appender.append(LogEvent.newBuilder().level("ERROR").message(e.getMessage()).exception(e).build());
                }
            }
            catch (Throwable t) {
                LOGGER.info("Unable to queue exception to Stackify Log API service: {}", (Object)e, (Object)t);
            }
        }
    }

    public static void queueException(String level, String message, Throwable e) {
        try {
            LogAppender<LogEvent> appender = LogManager.getAppender();
            if (appender != null) {
                appender.append(LogEvent.newBuilder().level(level).message(message).exception(e).build());
            }
        }
        catch (Throwable t) {
            LOGGER.info("Unable to queue exception to Stackify Log API service: {} {} {}", new Object[]{level, message, e, t});
        }
    }

    private Logger() {
    }
}

