/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.lang;

import com.stackify.api.TraceFrame;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class StackTraceElements {
    public static TraceFrame toTraceFrame(StackTraceElement element) {
        TraceFrame.Builder builder = TraceFrame.newBuilder();
        builder.codeFileName(element.getFileName());
        if (0 < element.getLineNumber()) {
            builder.lineNum(Integer.valueOf(element.getLineNumber()));
        }
        builder.method(element.getClassName() + "." + element.getMethodName());
        builder.libraryName(StackTraceElements.getLibraryName(element.getClassName()));
        return builder.build();
    }

    private static String getLibraryName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            ProtectionDomain domain = clazz.getProtectionDomain();
            CodeSource codeSource = domain.getCodeSource();
            URL location = codeSource.getLocation();
            URI uri = location.toURI();
            return uri.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private StackTraceElements() {
    }
}

