/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.google.common.base.Preconditions;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.EnvironmentDetails;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiConfigurations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiConfigurations.class);

    public static ApiConfiguration from(String apiUrl, String apiKey, String application, String environment) {
        Preconditions.checkNotNull((Object)apiKey);
        Preconditions.checkArgument((!apiKey.isEmpty() ? 1 : 0) != 0);
        ApiConfiguration.Builder builder = ApiConfiguration.newBuilder();
        builder.apiUrl(apiUrl);
        builder.apiKey(apiKey);
        builder.application(application);
        builder.environment(environment);
        builder.envDetail(EnvironmentDetails.getEnvironmentDetail(application, environment));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiConfiguration fromProperties() {
        ApiConfiguration.Builder builder = ApiConfiguration.newBuilder();
        InputStreamReader confFileReader = null;
        try {
            URL confFileUrl = ClassLoader.getSystemResource("stackify-api.properties");
            File confFile = new File(confFileUrl.toURI());
            if (confFile.exists()) {
                confFileReader = new FileReader(confFile);
                Properties confProps = new Properties();
                confProps.load(confFileReader);
                String apiUrl = null;
                if (confProps.containsKey("stackify.apiUrl")) {
                    apiUrl = confProps.getProperty("stackify.apiUrl");
                }
                String apiKey = confProps.getProperty("stackify.apiKey");
                String application = confProps.getProperty("stackify.application");
                String environment = confProps.getProperty("stackify.environment");
                builder.apiUrl(apiUrl);
                builder.apiKey(apiKey);
                builder.application(application);
                builder.environment(environment);
                builder.envDetail(EnvironmentDetails.getEnvironmentDetail(application, environment));
            }
        }
        catch (Throwable t) {
            LOGGER.error("Exception reading stackify-api.properties configuration file", t);
        }
        finally {
            if (confFileReader != null) {
                try {
                    confFileReader.close();
                }
                catch (Throwable t) {
                    LOGGER.info("Exception closing stackify-api.properties configuration file", t);
                }
            }
        }
        return builder.build();
    }

    private ApiConfigurations() {
    }
}

