/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import java.io.IOException;

public class LogSender {
    private final ApiConfiguration apiConfig;
    private final ObjectMapper objectMapper;

    public LogSender(ApiConfiguration apiConfig, ObjectMapper objectMapper) {
        Preconditions.checkNotNull((Object)apiConfig);
        Preconditions.checkNotNull((Object)objectMapper);
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
    }

    public int send(LogMsgGroup group) throws IOException {
        Preconditions.checkNotNull((Object)group);
        String jsonString = this.objectMapper.writer().writeValueAsString((Object)group);
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes((Object)group);
        HttpClient httpClient = new HttpClient(this.apiConfig);
        int statusCode = 500;
        try {
            httpClient.post("/Log/Save", jsonBytes, true);
            statusCode = 200;
        }
        catch (HttpException e) {
            statusCode = e.getStatusCode();
        }
        return statusCode;
    }
}

