/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.error.ErrorGovernor;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.LogBackgroundService;
import com.stackify.api.common.log.LogCollector;
import com.stackify.api.common.log.LogSender;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LogAppender<T>
implements Closeable {
    private final String logger;
    private final EventAdapter<T> eventAdapter;
    private LogCollector collector = null;
    private LogBackgroundService backgroundService = null;
    private final ErrorGovernor errorGovernor = new ErrorGovernor();

    public LogAppender(String logger, EventAdapter<T> eventAdapter) {
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkArgument((!logger.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull(eventAdapter);
        this.logger = logger;
        this.eventAdapter = eventAdapter;
    }

    public void activate(ApiConfiguration apiConfig) {
        Preconditions.checkNotNull((Object)apiConfig);
        Preconditions.checkNotNull((Object)apiConfig.getApiUrl());
        Preconditions.checkArgument((!apiConfig.getApiUrl().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)apiConfig.getApiKey());
        Preconditions.checkArgument((!apiConfig.getApiKey().isEmpty() ? 1 : 0) != 0);
        ObjectMapper objectMapper = new ObjectMapper();
        AppIdentityService appIdentityService = new AppIdentityService(apiConfig, objectMapper);
        this.collector = new LogCollector(this.logger, apiConfig.getEnvDetail(), appIdentityService);
        LogSender sender = new LogSender(apiConfig, objectMapper);
        this.backgroundService = new LogBackgroundService(this.collector, sender);
        try {
            this.backgroundService.startAsync().awaitRunning(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.backgroundService != null) {
            try {
                this.backgroundService.stopAsync().awaitTerminated(5L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public void appendError(T event) {
        if (this.backgroundService == null) {
            return;
        }
        if (!this.backgroundService.isRunning()) {
            return;
        }
        Optional<Throwable> exception = this.eventAdapter.getThrowable(event);
        if (!exception.isPresent()) {
            return;
        }
        StackifyError error = this.eventAdapter.getStackifyError(event, (Throwable)exception.get());
        if (this.errorGovernor.errorShouldBeSent(error)) {
            LogMsg logMsg = this.eventAdapter.getLogMsg(event, (Optional<StackifyError>)Optional.of((Object)error));
            this.collector.addLogMsg(logMsg);
        }
    }

    public void append(T event) {
        StackifyError e;
        if (this.backgroundService == null) {
            return;
        }
        if (!this.backgroundService.isRunning()) {
            return;
        }
        Optional<Throwable> exception = this.eventAdapter.getThrowable(event);
        Optional error = Optional.absent();
        if (exception.isPresent() && this.errorGovernor.errorShouldBeSent(e = this.eventAdapter.getStackifyError(event, (Throwable)exception.orNull()))) {
            error = Optional.of((Object)e);
        }
        LogMsg logMsg = this.eventAdapter.getLogMsg(event, (Optional<StackifyError>)error);
        this.collector.addLogMsg(logMsg);
    }
}

