/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.stackify.api.ErrorItem;
import com.stackify.api.LogMsg;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.mask.Masker;
import com.stackify.api.common.util.SkipJsonUtil;
import java.util.Map;

public class LogTransportPreProcessor {
    private final Masker masker;
    private final boolean skipJson;

    public LogTransportPreProcessor(Masker masker, boolean skipJson) {
        this.masker = masker;
        this.skipJson = skipJson;
    }

    public void execute(LogMsgGroup group) {
        this.executeMask(group);
        this.executeSkipJsonTag(group);
    }

    private void executeSkipJsonTag(LogMsgGroup group) {
        if (this.skipJson && group.getMsgs().size() > 0) {
            for (LogMsg logMsg : group.getMsgs()) {
                if (logMsg.getEx() != null) {
                    this.executeSkipJsonTag(logMsg.getEx().getError());
                }
                logMsg.setData(SkipJsonUtil.execute(logMsg.getData()));
                logMsg.setMsg(SkipJsonUtil.execute(logMsg.getMsg()));
            }
        }
    }

    private void executeSkipJsonTag(ErrorItem errorItem) {
        if (this.skipJson && errorItem != null) {
            errorItem.setMessage(SkipJsonUtil.execute(errorItem.getMessage()));
            if (errorItem.getData() != null) {
                for (Map.Entry<String, String> entry : errorItem.getData().entrySet()) {
                    entry.setValue(SkipJsonUtil.execute(entry.getValue()));
                }
            }
            this.executeSkipJsonTag(errorItem.getInnerError());
        }
    }

    private void executeMask(ErrorItem errorItem) {
        if (errorItem != null) {
            errorItem.setMessage(this.masker.mask(errorItem.getMessage()));
            if (errorItem.getData() != null) {
                for (Map.Entry<String, String> entry : errorItem.getData().entrySet()) {
                    entry.setValue(this.masker.mask(entry.getValue()));
                }
            }
            this.executeMask(errorItem.getInnerError());
        }
    }

    private void executeMask(LogMsgGroup group) {
        if (this.masker != null && group.getMsgs() != null && group.getMsgs().size() > 0) {
            for (LogMsg logMsg : group.getMsgs()) {
                if (logMsg.getEx() != null) {
                    this.executeMask(logMsg.getEx().getError());
                }
                logMsg.setData(this.masker.mask(logMsg.getData()));
                logMsg.setMsg(this.masker.mask(logMsg.getMsg()));
            }
        }
    }
}

