/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api;

public class TraceFrame {
    private final String codeFileName;
    private final Integer lineNum;
    private final String method;
    private final String libraryName;

    public String getCodeFileName() {
        return this.codeFileName;
    }

    public Integer getLineNum() {
        return this.lineNum;
    }

    public String getMethod() {
        return this.method;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    private TraceFrame(Builder builder) {
        this.codeFileName = builder.codeFileName;
        this.lineNum = builder.lineNum;
        this.method = builder.method;
        this.libraryName = builder.libraryName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String codeFileName;
        private Integer lineNum;
        private String method;
        private String libraryName;

        public Builder codeFileName(String codeFileName) {
            this.codeFileName = codeFileName;
            return this;
        }

        public Builder lineNum(Integer lineNum) {
            this.lineNum = lineNum;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder libraryName(String libraryName) {
            this.libraryName = libraryName;
            return this;
        }

        public TraceFrame build() {
            return new TraceFrame(this);
        }
    }
}

