/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.ApiClient;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.ErrorItem;
import com.stackify.api.StackifyError;
import com.stackify.api.TraceFrame;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.json.StackifyErrorConverter;
import com.stackify.api.json.jackson.ApiClientMixIn;
import com.stackify.api.json.jackson.EnvironmentDetailMixIn;
import com.stackify.api.json.jackson.ErrorItemMixIn;
import com.stackify.api.json.jackson.StackifyErrorMixIn;
import com.stackify.api.json.jackson.TraceFrameMixIn;
import com.stackify.api.json.jackson.WebRequestDetailMixIn;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class StackifyErrorJacksonConverter
implements StackifyErrorConverter {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public StackifyErrorJacksonConverter() {
        this.objectMapper.addMixInAnnotations(StackifyError.class, StackifyErrorMixIn.class);
        this.objectMapper.addMixInAnnotations(ApiClient.class, ApiClientMixIn.class);
        this.objectMapper.addMixInAnnotations(EnvironmentDetail.class, EnvironmentDetailMixIn.class);
        this.objectMapper.addMixInAnnotations(ErrorItem.class, ErrorItemMixIn.class);
        this.objectMapper.addMixInAnnotations(TraceFrame.class, TraceFrameMixIn.class);
        this.objectMapper.addMixInAnnotations(WebRequestDetail.class, WebRequestDetailMixIn.class);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public void writeToStream(List<StackifyError> errors, OutputStream stream) {
        if (errors == null) {
            throw new NullPointerException("StackifyError is null");
        }
        if (stream == null) {
            throw new NullPointerException("OutputStream is null");
        }
        try {
            this.objectMapper.writer().writeValue(stream, errors);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

