/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.error.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.ApiConfigurations;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.LogAppender;
import com.stackify.log.logback.ILoggingEventAdapter;

public class StackifyErrorAppender
extends AppenderBase<ILoggingEvent> {
    private String apiUrl = "https://api.stackify.com";
    private String apiKey = null;
    private String application = null;
    private String environment = null;
    private LogAppender<ILoggingEvent> logAppender;

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void start() {
        super.start();
        ApiConfiguration apiConfig = ApiConfigurations.from((String)this.apiUrl, (String)this.apiKey, (String)this.application, (String)this.environment);
        try {
            this.logAppender = new LogAppender("stackify-error-logback", (EventAdapter)new ILoggingEventAdapter(apiConfig.getEnvDetail()));
            this.logAppender.activate(apiConfig);
        }
        catch (Exception e) {
            this.addError("Exception starting the Stackify_LogBackgroundService");
        }
    }

    protected void append(ILoggingEvent event) {
        try {
            this.logAppender.appendError((Object)event);
        }
        catch (Exception e) {
            this.addError("Exception appending event to Stackify Error Appender", e);
        }
    }

    public void stop() {
        try {
            this.logAppender.close();
        }
        catch (Exception e) {
            this.addError("Exception closing Stackify Error Appender", e);
        }
        super.stop();
    }
}

