/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.log4j12;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.APMLogData;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.ServletLogContext;
import com.stackify.api.common.util.Maps;
import com.stackify.api.common.util.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class LoggingEventAdapter
implements EventAdapter<LoggingEvent> {
    private final EnvironmentDetail envDetail;
    private final ObjectMapper json = new ObjectMapper();

    public LoggingEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull((Object)envDetail);
        this.envDetail = envDetail;
    }

    public Throwable getThrowable(LoggingEvent event) {
        Throwable t;
        ThrowableInformation throwableInfo = event.getThrowableInformation();
        if (throwableInfo != null && (t = throwableInfo.getThrowable()) != null) {
            return t;
        }
        Object message = event.getMessage();
        if (message != null && message instanceof Throwable) {
            return (Throwable)message;
        }
        return null;
    }

    public StackifyError getStackifyError(LoggingEvent event, Throwable exception) {
        WebRequestDetail webRequest;
        String user;
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimeStamp()));
        if (exception != null) {
            builder.error(Throwables.toErrorItem((String)this.getMessage(event), (Throwable)exception));
        } else {
            String className = null;
            String methodName = null;
            int lineNumber = 0;
            LocationInfo locInfo = event.getLocationInformation();
            if (locInfo != null) {
                className = locInfo.getClassName();
                methodName = locInfo.getMethodName();
                try {
                    lineNumber = Integer.parseInt(locInfo.getLineNumber());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            builder.error(Throwables.toErrorItem((String)this.getMessage(event), (String)className, (String)methodName, (int)lineNumber));
        }
        String string = user = APMLogData.isLinked() ? APMLogData.getUser() : ServletLogContext.getUser();
        if (user != null) {
            builder.userName(user);
        }
        WebRequestDetail webRequestDetail = webRequest = APMLogData.isLinked() ? APMLogData.getWebRequest() : ServletLogContext.getWebRequest();
        if (webRequest != null) {
            builder.webRequestDetail(webRequest);
        }
        builder.serverVariables(Maps.fromProperties((Properties)System.getProperties()));
        return builder.build();
    }

    public LogMsg getLogMsg(LoggingEvent event, StackifyError error) {
        LocationInfo locInfo;
        String transactionId;
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(this.getMessage(event));
        Map<String, String> props = this.getProperties(event);
        if (!props.isEmpty()) {
            try {
                builder.data(this.json.writeValueAsString(props));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        builder.ex(error);
        builder.th(event.getThreadName());
        builder.epochMs(Long.valueOf(event.getTimeStamp()));
        builder.level(event.getLevel().toString().toLowerCase());
        String string = transactionId = APMLogData.isLinked() ? APMLogData.getTransactionId() : ServletLogContext.getTransactionId();
        if (transactionId != null) {
            builder.transId(transactionId);
        }
        if ((locInfo = event.getLocationInformation()) != null) {
            builder.srcMethod(locInfo.getClassName() + "." + locInfo.getMethodName());
            try {
                builder.srcLine(Integer.valueOf(Integer.parseInt(locInfo.getLineNumber())));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public String getMessage(LoggingEvent event) {
        Object message = event.getMessage();
        if (message != null && message instanceof String) {
            return (String)message;
        }
        return null;
    }

    public Map<String, String> getProperties(LoggingEvent event) {
        String ndc;
        HashMap<String, String> properties = new HashMap<String, String>();
        Map mdc = event.getProperties();
        if (mdc != null) {
            for (Map.Entry entryPair : mdc.entrySet()) {
                Object key = entryPair.getKey();
                Object value = entryPair.getValue();
                properties.put(key.toString(), value != null ? value.toString() : null);
            }
        }
        if ((ndc = event.getNDC()) != null && !ndc.isEmpty()) {
            properties.put("NDC", ndc);
        }
        return properties;
    }

    public boolean isErrorLevel(LoggingEvent event) {
        return event.getLevel().isGreaterOrEqual((Priority)Level.ERROR);
    }

    public String getClassName(LoggingEvent event) {
        LocationInfo locInfo = event.getLocationInformation();
        if (locInfo != null) {
            return locInfo.getClassName();
        }
        return null;
    }
}

