/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.log4j12;

import com.stackify.api.common.ApiClients;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.ApiConfigurations;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.LogAppender;
import com.stackify.api.common.mask.Masker;
import com.stackify.log.log4j12.LoggingEventAdapter;
import com.stackify.log.log4j12.NonReentrantAppender;
import org.apache.log4j.spi.LoggingEvent;

public class StackifyLogAppender
extends NonReentrantAppender {
    private String apiUrl = "https://api.stackify.com";
    private String apiKey = null;
    private String application = null;
    private String environment = null;
    private LogAppender<LoggingEvent> logAppender;
    private String skipJson = "false";
    private String maskEnabled;
    private String maskCreditCard;
    private String maskSSN;
    private String maskIP;
    private String maskCustom;

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void activateOptions() {
        super.activateOptions();
        ApiConfiguration apiConfig = ApiConfigurations.fromPropertiesWithOverrides((String)this.apiUrl, (String)this.apiKey, (String)this.application, (String)this.environment);
        String clientName = ApiClients.getApiClient(StackifyLogAppender.class, (String)"/stackify-log-log4j12.properties", (String)"stackify-log-log4j12");
        try {
            Masker masker = new Masker();
            if (this.maskEnabled != null && Boolean.parseBoolean(this.maskEnabled)) {
                masker.addMask("CREDITCARD");
                masker.addMask("SSN");
                if (this.maskCreditCard != null && !Boolean.parseBoolean(this.maskCreditCard)) {
                    masker.removeMask("CREDITCARD");
                }
                if (this.maskSSN != null && !Boolean.parseBoolean(this.maskSSN)) {
                    masker.removeMask("SSN");
                }
                if (this.maskIP != null && Boolean.parseBoolean(this.maskIP)) {
                    masker.addMask("IP");
                }
                if (this.maskCustom != null) {
                    masker.addMask(this.maskCustom);
                }
            } else {
                masker.clearMasks();
            }
            this.logAppender = new LogAppender(clientName, (EventAdapter)new LoggingEventAdapter(apiConfig.getEnvDetail()), masker, this.skipJson != null && Boolean.parseBoolean(this.skipJson));
            this.logAppender.activate(apiConfig);
        }
        catch (Exception e) {
            this.errorHandler.error("Exception starting the Stackify_LogBackgroundService", e, 0);
        }
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        try {
            this.logAppender.append((Object)event);
        }
        catch (Exception e) {
            this.errorHandler.error("Exception appending event to Stackify Log Appender", e, 0);
        }
    }

    public void close() {
        try {
            this.logAppender.close();
        }
        catch (Exception e) {
            this.errorHandler.error("Exception closing Stackify Log Appender", e, 0);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setSkipJson(String skipJson) {
        this.skipJson = skipJson;
    }

    public String getSkipJson() {
        return this.skipJson;
    }

    public void setMaskEnabled(String maskEnabled) {
        this.maskEnabled = maskEnabled;
    }

    public String getMaskEnabled() {
        return this.maskEnabled;
    }

    public void setMaskCreditCard(String maskCreditCard) {
        this.maskCreditCard = maskCreditCard;
    }

    public String getMaskCreditCard() {
        return this.maskCreditCard;
    }

    public void setMaskSSN(String maskSSN) {
        this.maskSSN = maskSSN;
    }

    public String getMaskSSN() {
        return this.maskSSN;
    }

    public void setMaskIP(String maskIP) {
        this.maskIP = maskIP;
    }

    public String getMaskIP() {
        return this.maskIP;
    }

    public void setMaskCustom(String maskCustom) {
        this.maskCustom = maskCustom;
    }

    public String getMaskCustom() {
        return this.maskCustom;
    }
}

